/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.CodeTemplateManager;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.CustomModePanel;
import org.apache.cayenne.modeler.dialog.codegen.CustomPreferencesUpdater;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorController;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.util.Util;

public class CustomModeController
extends GeneratorController {
    private static final String MODE_ENTITY = "entity";
    protected CustomModePanel view;
    private CodeTemplateManager templateManager;
    private ObjectBinding superTemplate;
    private ObjectBinding subTemplate;
    private CustomPreferencesUpdater preferencesUpdater;

    public CustomPreferencesUpdater getCustomPreferencesUpdater() {
        return this.preferencesUpdater;
    }

    public CustomModeController(CodeGeneratorControllerBase parent) {
        super(parent);
        Set<Map.Entry<DataMap, DataMapDefaults>> entities = this.getMapPreferences().entrySet();
        for (Map.Entry<DataMap, DataMapDefaults> entry : entities) {
            if (Util.isEmptyString(entry.getValue().getSuperclassTemplate())) {
                entry.getValue().setSuperclassTemplate("Standard Server Superclass");
            }
            if (Util.isEmptyString(entry.getValue().getSubclassTemplate())) {
                entry.getValue().setSubclassTemplate("Standard Server Subclass");
            }
            if (Util.isEmptyString(entry.getValue().getProperty("mode"))) {
                entry.getValue().setProperty("mode", MODE_ENTITY);
            }
            if (Util.isEmptyString(entry.getValue().getProperty("overwrite"))) {
                entry.getValue().setBooleanProperty("overwrite", false);
            }
            if (Util.isEmptyString(entry.getValue().getProperty("pairs"))) {
                entry.getValue().setBooleanProperty("pairs", true);
            }
            if (Util.isEmptyString(entry.getValue().getProperty("usePackagePath"))) {
                entry.getValue().setBooleanProperty("usePackagePath", true);
            }
            if (!Util.isEmptyString(entry.getValue().getProperty("outputPattern"))) continue;
            entry.getValue().setProperty("outputPattern", "*.java");
        }
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getManageTemplatesLink(), "popPreferencesAction()");
        builder.bindToStateChange(this.view.getOverwrite(), "customPreferencesUpdater.overwrite").updateView();
        builder.bindToStateChange(this.view.getPairs(), "customPreferencesUpdater.pairs").updateView();
        builder.bindToStateChange(this.view.getUsePackagePath(), "customPreferencesUpdater.usePackagePath").updateView();
        this.subTemplate = builder.bindToComboSelection(this.view.getSubclassTemplate(), "customPreferencesUpdater.subclassTemplate");
        this.superTemplate = builder.bindToComboSelection(this.view.getSuperclassTemplate(), "customPreferencesUpdater.superclassTemplate");
        builder.bindToTextField(this.view.getOutputPattern(), "customPreferencesUpdater.outputPattern").updateView();
        builder.bindToStateChange(this.view.getCreatePropertyNames(), "customPreferencesUpdater.createPropertyNames").updateView();
        this.updateTemplates();
    }

    @Override
    protected void createDefaults() {
        TreeMap<DataMap, DataMapDefaults> map = new TreeMap<DataMap, DataMapDefaults>();
        Collection<DataMap> dataMaps = this.getParentController().getDataMaps();
        for (DataMap dataMap : dataMaps) {
            DataMapDefaults preferences = this.getApplication().getFrameController().getProjectController().getDataMapPreferences(this.getClass().getName().replace(".", "/"), dataMap);
            preferences.setSuperclassPackage("");
            preferences.updateSuperclassPackage(dataMap, false);
            map.put(dataMap, preferences);
            if (this.getOutputPath() != null) continue;
            this.setOutputPath(preferences.getOutputPath());
        }
        this.setMapPreferences(map);
        this.preferencesUpdater = new CustomPreferencesUpdater(map);
    }

    @Override
    protected GeneratorControllerPanel createView() {
        this.view = new CustomModePanel();
        return this.view;
    }

    private void updateTemplates() {
        this.templateManager = this.getApplication().getCodeTemplateManager();
        ArrayList<String> customTemplates = new ArrayList<String>(this.templateManager.getCustomTemplates().keySet());
        Collections.sort(customTemplates);
        ArrayList<String> superTemplates = new ArrayList<String>(this.templateManager.getStandardSuperclassTemplates());
        Collections.sort(superTemplates);
        superTemplates.addAll(customTemplates);
        ArrayList<String> subTemplates = new ArrayList<String>(this.templateManager.getStandardSubclassTemplates());
        Collections.sort(subTemplates);
        subTemplates.addAll(customTemplates);
        this.view.getSubclassTemplate().setModel(new DefaultComboBoxModel<String>(subTemplates.toArray(new String[0])));
        this.view.getSuperclassTemplate().setModel(new DefaultComboBoxModel<String>(superTemplates.toArray(new String[0])));
        JCheckBox pairs = this.view.getPairs();
        this.updateView();
        pairs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomModeController.this.updateView();
            }
        });
        this.superTemplate.updateView();
        this.subTemplate.updateView();
    }

    private void updateView() {
        boolean selected = this.view.getPairs().isSelected();
        JComboBox<String> subclassTemplate = this.view.getSubclassTemplate();
        subclassTemplate.setSelectedItem(selected ? "Standard Server Subclass" : "Single Server class");
        this.view.getSuperclassTemplate().setEnabled(selected);
        this.view.getOverwrite().setEnabled(!selected);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public Collection<ClassGenerationAction> createGenerator() {
        Collection<ClassGenerationAction> generators = super.createGenerator();
        String superKey = Objects.requireNonNull(this.view.getSuperclassTemplate().getSelectedItem()).toString();
        String superTemplate = this.templateManager.getTemplatePath(superKey);
        String subKey = Objects.requireNonNull(this.view.getSubclassTemplate().getSelectedItem()).toString();
        String subTemplate = this.templateManager.getTemplatePath(subKey);
        for (ClassGenerationAction generator : generators) {
            generator.setSuperTemplate(superTemplate);
            generator.setTemplate(subTemplate);
            generator.setOverwrite(this.view.getOverwrite().isSelected());
            generator.setUsePkgPath(this.view.getUsePackagePath().isSelected());
            generator.setMakePairs(this.view.getPairs().isSelected());
            generator.setCreatePropertyNames(this.view.getCreatePropertyNames().isSelected());
            if (Util.isEmptyString(this.view.getOutputPattern().getText())) continue;
            generator.setOutputPattern(this.view.getOutputPattern().getText());
        }
        return generators;
    }

    public void popPreferencesAction() {
        new PreferenceDialog(this.getApplication().getFrameController()).startupAction("Templates");
        this.updateTemplates();
    }

    @Override
    protected ClassGenerationAction newGenerator() {
        ClassGenerationAction action = new ClassGenerationAction();
        this.getApplication().getInjector().injectMembers(action);
        return action;
    }
}

