/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.DbAdapterInfo;
import org.apache.cayenne.modeler.util.JUndoableCayenneTextPane;
import org.apache.cayenne.swing.components.textpane.JCayenneTextPane;
import org.apache.cayenne.swing.components.textpane.syntax.SQLSyntaxConstants;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTemplateScriptsTab
extends JPanel {
    private static final String DEFAULT_LABEL = "Default";
    private static final Logger logger = LoggerFactory.getLogger(SQLTemplateScriptsTab.class);
    protected ProjectController mediator;
    protected JList<String> scripts;
    protected List<String> keys;
    protected PanelBuilder builder;
    protected CellConstraints cc;
    protected JCayenneTextPane textPane;
    protected List<JCayenneTextPane> panes;
    protected ListSelectionListener scriptRefreshHandler;

    public SQLTemplateScriptsTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    private void prepareScriptAreas() {
        for (String key : DbAdapterInfo.getStandardAdapters()) {
            JUndoableCayenneTextPane currPane = new JUndoableCayenneTextPane(new SQLSyntaxConstants());
            currPane.setName(key);
            currPane.getDocument().addDocumentListener(new CustomListener(currPane.getName()));
            this.builder.add((Component)currPane.getScrollPane(), this.cc.xy(3, 2));
            this.panes.add(currPane);
        }
    }

    protected void initView() {
        this.scriptRefreshHandler = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SQLTemplateScriptsTab.this.displayScript();
                }
            }
        };
        this.scripts = new JList();
        this.scripts.setSelectionMode(0);
        this.scripts.setCellRenderer(new DbAdapterListRenderer(DbAdapterInfo.getStandardAdapterLabels()));
        this.keys = new ArrayList<String>(DbAdapterInfo.getStandardAdapters().length + 1);
        this.keys.addAll(Arrays.asList(DbAdapterInfo.getStandardAdapters()));
        Collections.sort(this.keys);
        this.keys.add(0, DEFAULT_LABEL);
        this.scripts.setModel(new DefaultComboBoxModel<String>(this.keys.toArray(new String[0])));
        this.cc = new CellConstraints();
        this.textPane = new JUndoableCayenneTextPane(new SQLSyntaxConstants());
        this.textPane.setName(DEFAULT_LABEL);
        this.textPane.getDocument().addDocumentListener(new CustomListener(this.textPane.getName()));
        this.panes = new ArrayList<JCayenneTextPane>();
        this.panes.add(this.textPane);
        this.builder = new PanelBuilder(new FormLayout("fill:100dlu, 3dlu, fill:100dlu:grow", "3dlu, fill:100dlu:grow"));
        this.builder.add((Component)new JScrollPane(this.scripts, 20, 31), this.cc.xy(1, 2));
        this.builder.add((Component)this.textPane.getScrollPane(), this.cc.xy(3, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)this.builder.getPanel(), "Center");
        this.prepareScriptAreas();
    }

    void initFromModel() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        if (query == null || !"SQLTemplate".equals(query.getType())) {
            this.setVisible(false);
            return;
        }
        this.scripts.removeListSelectionListener(this.scriptRefreshHandler);
        this.scripts.setSelectedIndex(0);
        this.displayScript();
        this.scripts.addListSelectionListener(this.scriptRefreshHandler);
        this.setVisible(true);
    }

    String getSQLTemplate(String key) {
        if (key == null) {
            return null;
        }
        SQLTemplateDescriptor query = this.getQuery();
        if (query == null) {
            return null;
        }
        return key.equals(DEFAULT_LABEL) ? query.getSql() : query.getAdapterSql().get(key);
    }

    SQLTemplateDescriptor getQuery() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        return query != null && "SQLTemplate".equals(query.getType()) ? (SQLTemplateDescriptor)query : null;
    }

    void displayScript() {
        SQLTemplateDescriptor query = this.getQuery();
        if (query == null) {
            return;
        }
        String key = this.scripts.getSelectedValue();
        if (key == null) {
            return;
        }
        String text = key.equals(DEFAULT_LABEL) ? query.getSql() : query.getAdapterSql().get(key);
        for (JCayenneTextPane textPane : this.panes) {
            if (key.equals(textPane.getName())) {
                textPane.setDocumentTextDirect(text);
                textPane.getScrollPane().setVisible(true);
                textPane.getPane().requestFocusInWindow();
                continue;
            }
            textPane.getScrollPane().setVisible(false);
        }
    }

    void setSQL(DocumentEvent e, String key) {
        if (key == null) {
            return;
        }
        SQLTemplateDescriptor query = this.getQuery();
        if (query == null) {
            return;
        }
        Document doc = e.getDocument();
        String text = null;
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            logger.warn("Error reading document", ex);
        }
        if (text != null && (text = text.trim()).length() == 0) {
            text = null;
        }
        if (key.equals(DEFAULT_LABEL)) {
            if (!Util.nullSafeEquals(text, query.getSql())) {
                query.setSql(text);
                this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
            }
        } else if (!Util.nullSafeEquals(text, query.getAdapterSql().get(key))) {
            query.getAdapterSql().put(key, text);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
        }
    }

    public int getSelectedIndex() {
        return this.scripts.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.scripts.setSelectedIndex(index);
    }

    final class DbAdapterListRenderer
    extends DefaultListCellRenderer {
        Map adapterLabels;

        DbAdapterListRenderer(Map adapterLabels) {
            this.adapterLabels = adapterLabels != null ? adapterLabels : Collections.EMPTY_MAP;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object object, int index, boolean selected, boolean hasFocus) {
            Object label;
            if (object instanceof Class) {
                object = ((Class)object).getName();
            }
            if ((label = this.adapterLabels.get(object)) == null) {
                label = object;
            }
            Component c = super.getListCellRendererComponent((JList<?>)list, label, index, selected, hasFocus);
            this.setForeground(selected || SQLTemplateScriptsTab.this.getSQLTemplate(object.toString()) != null ? Color.BLACK : Color.LIGHT_GRAY);
            return c;
        }
    }

    final class CustomListener
    implements DocumentListener {
        private String key;

        public CustomListener(String key) {
            this.key = key;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SQLTemplateScriptsTab.this.setSQL(e, this.key);
        }
    }
}

