/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.SelectQueryOrderingTab;
import org.apache.cayenne.modeler.undo.AddPrefetchUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.EntityTreeFilter;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.swing.components.image.FilteredIconFactory;

public class SelectQueryPrefetchTab
extends SelectQueryOrderingTab {
    public SelectQueryPrefetchTab(ProjectController mediator) {
        super(mediator);
    }

    @Override
    protected JComponent createToolbar() {
        CayenneAction.CayenneToolbarButton add = new CayenneAction.CayenneToolbarButton(null, 1);
        ((AbstractButton)add).setText("Add Prefetch");
        ImageIcon addIcon = ModelerUtil.buildIcon("icon-plus.png");
        add.setIcon(addIcon);
        add.setDisabledIcon(FilteredIconFactory.createDisabledIcon(addIcon));
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String prefetch = SelectQueryPrefetchTab.this.getSelectedPath();
                if (prefetch == null) {
                    return;
                }
                SelectQueryPrefetchTab.this.addPrefetch(prefetch);
                Application.getInstance().getUndoManager().addEdit(new AddPrefetchUndoableEdit(prefetch, SelectQueryPrefetchTab.this));
            }
        });
        CayenneAction.CayenneToolbarButton remove = new CayenneAction.CayenneToolbarButton(null, 3);
        ((AbstractButton)remove).setText("Remove Prefetch");
        ImageIcon removeIcon = ModelerUtil.buildIcon("icon-trash.png");
        remove.setIcon(removeIcon);
        remove.setDisabledIcon(FilteredIconFactory.createDisabledIcon(removeIcon));
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selection = SelectQueryPrefetchTab.this.table.getSelectedRow();
                if (selection < 0) {
                    return;
                }
                String prefetch = (String)SelectQueryPrefetchTab.this.table.getModel().getValueAt(selection, 0);
                SelectQueryPrefetchTab.this.removePrefetch(prefetch);
            }
        });
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(BorderFactory.createEmptyBorder());
        toolBar.setFloatable(false);
        toolBar.add(add);
        toolBar.add(remove);
        return toolBar;
    }

    @Override
    protected TreeModel createBrowserModel(Entity entity) {
        EntityTreeModel treeModel = new EntityTreeModel(entity);
        treeModel.setFilter(new EntityTreeFilter(){

            @Override
            public boolean attributeMatch(Object node, Attribute attr) {
                return false;
            }

            @Override
            public boolean relationshipMatch(Object node, Relationship rel) {
                return true;
            }
        });
        return treeModel;
    }

    @Override
    protected TableModel createTableModel() {
        return new PrefetchModel();
    }

    public void addPrefetch(String prefetch) {
        if (!this.selectQuery.getPrefetches().isEmpty() && this.selectQuery.getPrefetches().contains(prefetch)) {
            return;
        }
        this.selectQuery.addPrefetch(prefetch);
        this.table.setModel(this.createTableModel());
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, this.selectQuery));
    }

    public void removePrefetch(String prefetch) {
        this.selectQuery.removePrefetch(prefetch);
        this.table.setModel(this.createTableModel());
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, this.selectQuery));
    }

    boolean isToMany(String prefetch) {
        if (this.selectQuery == null) {
            return false;
        }
        Object root = this.selectQuery.getRoot();
        try {
            Expression exp = ExpressionFactory.exp(prefetch, new Object[0]);
            Object object = exp.evaluate(root);
            if (object instanceof Relationship) {
                return ((Relationship)object).isToMany();
            }
            return false;
        }
        catch (ExpressionException e) {
            return false;
        }
    }

    final class PrefetchModel
    extends AbstractTableModel {
        String[] prefetches;

        PrefetchModel() {
            if (SelectQueryPrefetchTab.this.selectQuery != null) {
                this.prefetches = new String[SelectQueryPrefetchTab.this.selectQuery.getPrefetches().size()];
                for (int i = 0; i < this.prefetches.length; ++i) {
                    this.prefetches[i] = SelectQueryPrefetchTab.this.selectQuery.getPrefetches().get(i);
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.prefetches != null ? this.prefetches.length : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.prefetches[row];
                }
                case 1: {
                    return SelectQueryPrefetchTab.this.isToMany(this.prefetches[row]) ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            throw new IndexOutOfBoundsException("Invalid column: " + column);
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            throw new IndexOutOfBoundsException("Invalid column: " + column);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Prefetch Path";
                }
                case 1: {
                    return "To Many";
                }
            }
            throw new IndexOutOfBoundsException("Invalid column: " + column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

