/*
 * Decompiled with CFR 0.152.
 */
package foundrylogic.vpp;

import foundrylogic.vpp.VPPEngineProperty;
import foundrylogic.vpp.log.VPPLogAdapterSupport;
import foundrylogic.vpp.log.VPPProjectLogAdapter;
import foundrylogic.vpp.log.VPPTaskLogAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.apache.velocity.app.VelocityEngine;

public class VPPEngine
extends DataType {
    private VelocityEngine velocityEngine;
    private List configurerList = new ArrayList();
    private boolean useVelocityLogger = false;

    public VelocityEngine getVelocityEngine() {
        if (this.velocityEngine == null) {
            this.velocityEngine = new VelocityEngine();
            try {
                this.defaultInit(this.velocityEngine);
                Project project = this.getProject();
                Iterator iterator = this.configurerList.iterator();
                while (iterator.hasNext()) {
                    Configurer configurer = (Configurer)iterator.next();
                    configurer.configure(this.velocityEngine, project);
                }
                this.velocityEngine.init();
            }
            catch (Exception exception) {
                throw new BuildException("could not initialize the VelocityEngine", (Throwable)exception);
            }
        }
        return this.velocityEngine;
    }

    protected void defaultInit(VelocityEngine velocityEngine) {
        Project project = this.getProject();
        if (!this.useVelocityLogger) {
            Task task = project.getThreadTask(Thread.currentThread());
            VPPLogAdapterSupport vPPLogAdapterSupport = null;
            vPPLogAdapterSupport = task != null ? new VPPTaskLogAdapter(task) : new VPPProjectLogAdapter(project);
            velocityEngine.setProperty("runtime.log.logsystem", vPPLogAdapterSupport);
        }
        velocityEngine.setProperty("file.resource.loader.path", project.getBaseDir().getAbsolutePath());
        velocityEngine.setProperty("velocimacro.library", "");
    }

    public void setUseVelocityLogger(boolean bl) {
        this.useVelocityLogger = bl;
    }

    public void addConfiguredProperty(VPPEngineProperty vPPEngineProperty) {
        this.configurerList.add(vPPEngineProperty);
    }

    public static interface Configurer {
        public void configure(VelocityEngine var1, Project var2);
    }
}

