/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.tree;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public abstract class JGraphAbstractTreeLayout
implements JGraphLayout {
    protected transient Map nodes = new Hashtable();
    protected int orientation = 1;
    protected double levelDistance = 30.0;
    protected double nodeDistance = 20.0;
    protected boolean positionMultipleTrees = false;
    protected double treeDistance = 30.0;
    protected double treeBoundary;
    protected Point2D oldOrigin;
    protected JGraphFacade graph;
    protected boolean routeTreeEdges = false;
    protected double[] lowerLevelValues;
    protected double[] upperLevelValues;

    public void run(JGraphFacade jGraphFacade) {
        this.graph = jGraphFacade;
        this.treeBoundary = -this.treeDistance;
        this.oldOrigin = jGraphFacade.getGraphOrigin();
        if (jGraphFacade.getRootCount() == 0) {
            jGraphFacade.findTreeRoots();
        }
    }

    public void setOrientation(int n) {
        if (n != 1 && n != 3 && n != 5 && n != 7) {
            throw new IllegalArgumentException("Orientation must be one of NORTH (1), EAST (3), SOUTH (5) or WEST (7)");
        }
        this.orientation = n;
    }

    public void setLevelDistance(double d) {
        this.levelDistance = d;
    }

    public void setNodeDistance(int n) {
        this.nodeDistance = n;
    }

    public double getLevelDistance() {
        return this.levelDistance;
    }

    public double getNodeDistance() {
        return this.nodeDistance;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isPositionMultipleTrees() {
        return this.positionMultipleTrees;
    }

    public void setPositionMultipleTrees(boolean bl) {
        this.positionMultipleTrees = bl;
    }

    public double getTreeDistance() {
        return this.treeDistance;
    }

    public void setTreeDistance(int n) {
        this.treeDistance = n;
    }

    public boolean getRouteTreeEdges() {
        return this.routeTreeEdges;
    }

    public void setRouteTreeEdges(boolean bl) {
        this.routeTreeEdges = bl;
    }

    protected class TreeNode {
        protected double width;
        protected double height;
        protected double x = 0.0;
        protected double y = 0.0;
        protected Object cell;

        public TreeNode(Object object) {
            this.cell = object;
            Rectangle2D rectangle2D = JGraphAbstractTreeLayout.this.graph.getBounds(object);
            if (rectangle2D != null) {
                if (JGraphAbstractTreeLayout.this.orientation == 1 || JGraphAbstractTreeLayout.this.orientation == 5) {
                    this.width = rectangle2D.getWidth();
                    this.height = rectangle2D.getHeight();
                } else {
                    this.width = rectangle2D.getHeight();
                    this.height = rectangle2D.getWidth();
                }
            }
        }

        protected void routeEdges(Point2D point2D) {
            List list = JGraphAbstractTreeLayout.this.graph.getIncomingEdges(this.cell, null, true, false);
            if (list != null && list.size() > 0) {
                Object e = list.get(0);
                List list2 = JGraphAbstractTreeLayout.this.graph.getPoints(e);
                ArrayList arrayList = new ArrayList(4);
                arrayList.add(list2.get(0));
                boolean bl = JGraphAbstractTreeLayout.this.orientation == 1 || JGraphAbstractTreeLayout.this.orientation == 5;
                boolean bl2 = JGraphAbstractTreeLayout.this.orientation == 1 || JGraphAbstractTreeLayout.this.orientation == 7;
                double d = bl2 ? -JGraphAbstractTreeLayout.this.levelDistance / 2.0 : JGraphAbstractTreeLayout.this.levelDistance / 2.0;
                Point2D.Double double_ = new Point2D.Double(point2D.getX(), (point2D.getY() + this.y) / 2.0 + d);
                Point2D.Double double_2 = new Point2D.Double(point2D.getX() + this.x, (point2D.getY() + this.y) / 2.0 + d);
                arrayList.add(double_);
                arrayList.add(double_2);
                arrayList.add(list2.get(list2.size() - 1));
                JGraphAbstractTreeLayout.this.graph.setPoints(e, arrayList);
                JGraphAbstractTreeLayout.this.graph.disableRouting(e);
            }
        }

        public double getWidth() {
            return this.width;
        }

        public void setWidth(double d) {
            this.width = d;
        }
    }
}

