/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph.extension;

import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.graph.GraphRegistry;
import org.apache.cayenne.modeler.graph.extension.GraphLoaderDelegate;
import org.apache.cayenne.modeler.graph.extension.GraphSaverDelegate;
import org.apache.cayenne.project.extension.BaseNamingDelegate;
import org.apache.cayenne.project.extension.LoaderDelegate;
import org.apache.cayenne.project.extension.ProjectExtension;
import org.apache.cayenne.project.extension.SaverDelegate;

public class GraphExtension
implements ProjectExtension {
    static final String NAMESPACE = "http://cayenne.apache.org/schema/10/graph";
    static final String GRAPH_SUFFIX = ".graph.xml";
    @Inject
    protected Provider<Application> applicationProvider;

    @Override
    public LoaderDelegate createLoaderDelegate() {
        return new GraphLoaderDelegate(this.applicationProvider.get());
    }

    @Override
    public SaverDelegate createSaverDelegate() {
        return new GraphSaverDelegate(this.applicationProvider.get().getMetaData());
    }

    @Override
    public ConfigurationNodeVisitor<String> createNamingDelegate() {
        return new BaseNamingDelegate(){

            @Override
            public String visitDataChannelDescriptor(DataChannelDescriptor channelDescriptor) {
                GraphRegistry registry = GraphExtension.this.applicationProvider.get().getMetaData().get(channelDescriptor, GraphRegistry.class);
                if (registry == null) {
                    return null;
                }
                return channelDescriptor.getName() + GraphExtension.GRAPH_SUFFIX;
            }
        };
    }
}

