/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.validation.ValidationResult;

public class UtilDateType
implements ExtendedType {
    public String getClassName() {
        return Date.class.getName();
    }

    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        return true;
    }

    protected Object convertToJdbcObject(Object val, int type) throws Exception {
        if (type == 91) {
            return new java.sql.Date(((Date)val).getTime());
        }
        if (type == 92) {
            return new Time(((Date)val).getTime());
        }
        if (type == 93) {
            return new Timestamp(((Date)val).getTime());
        }
        throw new IllegalArgumentException("Only DATE, TIME or TIMESTAMP can be mapped as '" + this.getClassName() + "', got " + TypesMapping.getSqlNameByType(type));
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        Date val = null;
        switch (type) {
            case 93: {
                val = rs.getTimestamp(index);
                break;
            }
            case 91: {
                val = rs.getDate(index);
                break;
            }
            case 92: {
                val = rs.getTime(index);
                break;
            }
            default: {
                Object object = rs.getObject(index);
                if (object != null && !(object instanceof Date)) {
                    throw new CayenneRuntimeException("Expected an instance of java.util.Date, instead got " + object.getClass().getName() + ", column index: " + index);
                }
                val = (Date)object;
            }
        }
        return val == null ? null : new Date(val.getTime());
    }

    public Object materializeObject(CallableStatement cs, int index, int type) throws Exception {
        Object val = null;
        switch (type) {
            case 93: {
                val = cs.getTimestamp(index);
                break;
            }
            case 91: {
                val = cs.getDate(index);
                break;
            }
            case 92: {
                val = cs.getTime(index);
                break;
            }
            default: {
                val = cs.getObject(index);
                if (val == null || val instanceof Date) break;
                String typeName = TypesMapping.getSqlNameByType(type);
                throw new ClassCastException("Expected a java.util.Date or subclass, instead fetched '" + val.getClass().getName() + "' for JDBC type " + typeName);
            }
        }
        return val == null ? null : new Date(((Date)val).getTime());
    }

    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setObject(pos, this.convertToJdbcObject(value, type), type);
        }
    }
}

