/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.pojo;

import org.apache.cayenne.Fault;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.BaseToOneProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.pojo.EnhancedPojoPropertyFaultHandler;

class EnhancedPojoToOneProperty
extends BaseToOneProperty {
    protected EnhancedPojoPropertyFaultHandler faultHandler;
    protected Fault fault;

    EnhancedPojoToOneProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, Accessor accessor, String reverseName, Fault fault) {
        super(owner, targetDescriptor, accessor, reverseName);
        this.faultHandler = new EnhancedPojoPropertyFaultHandler(owner.getObjectClass(), this.getName());
        this.fault = fault;
    }

    public boolean isFault(Object source) {
        return this.faultHandler.isFaultProperty(source);
    }

    public void invalidate(Object object) {
        this.faultHandler.setFaultProperty(object, true);
    }

    void resolveFault(Object object) {
        if (this.isFault(object)) {
            Object target = this.fault.resolveFault((Persistent)object, this.getName());
            this.writePropertyDirectly(object, null, target);
            this.faultHandler.setFaultProperty(object, false);
        }
    }

    public Object readProperty(Object object) throws PropertyException {
        this.resolveFault(object);
        return super.readProperty(object);
    }
}

