/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.tools.DbGeneratorTask;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.xml.sax.InputSource;

public abstract class CayenneTask
extends Task {
    protected Path classpath;
    protected DbAdapter adapter;
    protected File map;
    protected String driver;
    protected String url;
    protected String userName;
    protected String password;

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    private Path createClasspath() {
        if (null == this.classpath) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setMap(File map) {
        this.map = map;
    }

    public void setAdapter(String adapter) {
        ClassLoader loader = null;
        if (adapter != null) {
            try {
                loader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(DbGeneratorTask.class.getClassLoader());
                Class c = Util.getJavaClass((String)adapter);
                this.adapter = (DbAdapter)c.newInstance();
            }
            catch (Exception e) {
                throw new BuildException("Can't load DbAdapter: " + adapter, (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserName(String username) {
        this.userName = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected DataMap loadDataMap() throws Exception {
        InputSource in = new InputSource(this.map.getCanonicalPath());
        return new MapLoader().loadDataMap(in);
    }
}

