/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.oned;

import java.text.MessageFormat;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneBoundedRegion;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.euclidean.oned.OrientedPoint;
import org.apache.commons.geometry.euclidean.oned.OrientedPoints;
import org.apache.commons.geometry.euclidean.oned.RegionBSPTree1D;
import org.apache.commons.geometry.euclidean.oned.Vector1D;
import org.apache.commons.numbers.core.Precision;

public final class Interval
implements HyperplaneBoundedRegion<Vector1D> {
    private static final Interval FULL = new Interval(null, null);
    private final OrientedPoint minBoundary;
    private final OrientedPoint maxBoundary;

    private Interval(OrientedPoint minBoundary, OrientedPoint maxBoundary) {
        this.minBoundary = minBoundary;
        this.maxBoundary = maxBoundary;
    }

    public double getMin() {
        return this.minBoundary != null ? this.minBoundary.getLocation() : Double.NEGATIVE_INFINITY;
    }

    public double getMax() {
        return this.maxBoundary != null ? this.maxBoundary.getLocation() : Double.POSITIVE_INFINITY;
    }

    public OrientedPoint getMinBoundary() {
        return this.minBoundary;
    }

    public OrientedPoint getMaxBoundary() {
        return this.maxBoundary;
    }

    public boolean hasMinBoundary() {
        return this.minBoundary != null;
    }

    public boolean hasMaxBoundary() {
        return this.maxBoundary != null;
    }

    public boolean isInfinite() {
        return this.minBoundary == null || this.maxBoundary == null;
    }

    public boolean isFinite() {
        return !this.isInfinite();
    }

    public RegionLocation classify(Vector1D pt) {
        return this.classify(pt.getX());
    }

    public RegionLocation classify(double location) {
        RegionLocation minLoc = this.classifyWithBoundary(location, this.minBoundary);
        RegionLocation maxLoc = this.classifyWithBoundary(location, this.maxBoundary);
        if (minLoc == RegionLocation.BOUNDARY || maxLoc == RegionLocation.BOUNDARY) {
            return RegionLocation.BOUNDARY;
        }
        if (minLoc == RegionLocation.INSIDE && maxLoc == RegionLocation.INSIDE) {
            return RegionLocation.INSIDE;
        }
        return RegionLocation.OUTSIDE;
    }

    private RegionLocation classifyWithBoundary(double location, OrientedPoint boundary) {
        if (Double.isNaN(location)) {
            return RegionLocation.OUTSIDE;
        }
        if (boundary == null) {
            return RegionLocation.INSIDE;
        }
        HyperplaneLocation hyperLoc = boundary.classify(location);
        if (hyperLoc == HyperplaneLocation.ON) {
            return RegionLocation.BOUNDARY;
        }
        if (hyperLoc == HyperplaneLocation.PLUS) {
            return RegionLocation.OUTSIDE;
        }
        return RegionLocation.INSIDE;
    }

    public boolean contains(double x) {
        return this.classify(x) != RegionLocation.OUTSIDE;
    }

    public Vector1D project(Vector1D pt) {
        OrientedPoint boundary = null;
        if (this.minBoundary != null && this.maxBoundary != null) {
            double minOffset = this.minBoundary.offset(pt.getX());
            double maxOffset = this.maxBoundary.offset(pt.getX());
            double minDist = Math.abs(minOffset);
            double maxDist = Math.abs(maxOffset);
            boundary = maxDist < minDist || maxOffset > 0.0 ? this.maxBoundary : this.minBoundary;
        } else if (this.minBoundary != null) {
            boundary = this.minBoundary;
        } else if (this.maxBoundary != null) {
            boundary = this.maxBoundary;
        }
        return boundary != null ? boundary.project(pt) : null;
    }

    public Interval transform(Transform<Vector1D> transform) {
        OrientedPoint transformedMin = this.minBoundary != null ? this.minBoundary.transform(transform) : null;
        OrientedPoint transformedMax = this.maxBoundary != null ? this.maxBoundary.transform(transform) : null;
        return Interval.of(transformedMin, transformedMax);
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isFull() {
        return this.minBoundary == null && this.maxBoundary == null;
    }

    public double getSize() {
        if (this.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getMax() - this.getMin();
    }

    public double getBoundarySize() {
        return 0.0;
    }

    public Vector1D getCentroid() {
        if (this.isInfinite()) {
            return null;
        }
        double min = this.getMin();
        double max = this.getMax();
        return Vector1D.of(0.5 * (max - min) + min);
    }

    public Split<Interval> split(Hyperplane<Vector1D> splitter) {
        boolean lowIsMinus;
        OrientedPoint splitOrientedPoint = (OrientedPoint)splitter;
        Vector1D splitPoint = splitOrientedPoint.getPoint();
        HyperplaneLocation splitterMinLoc = this.minBoundary != null ? this.minBoundary.classify(splitPoint) : null;
        HyperplaneLocation splitterMaxLoc = this.maxBoundary != null ? this.maxBoundary.classify(splitPoint) : null;
        Interval low = null;
        Interval high = null;
        if (splitterMinLoc != HyperplaneLocation.ON || splitterMaxLoc != HyperplaneLocation.ON) {
            if (splitterMinLoc != null && splitterMinLoc != HyperplaneLocation.MINUS) {
                high = this;
            } else if (splitterMaxLoc != null && splitterMaxLoc != HyperplaneLocation.MINUS) {
                low = this;
            } else {
                low = new Interval(this.minBoundary, OrientedPoints.createPositiveFacing(splitPoint, splitOrientedPoint.getPrecision()));
                high = new Interval(OrientedPoints.createNegativeFacing(splitPoint, splitOrientedPoint.getPrecision()), this.maxBoundary);
            }
        }
        Interval minus = (lowIsMinus = splitOrientedPoint.isPositiveFacing()) ? low : high;
        Interval plus = lowIsMinus ? high : low;
        return new Split((Object)minus, (Object)plus);
    }

    public RegionBSPTree1D toTree() {
        return RegionBSPTree1D.from(this, new Interval[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[min= ").append(this.getMin()).append(", max= ").append(this.getMax()).append(']');
        return sb.toString();
    }

    public static Interval of(double a, double b, Precision.DoubleEquivalence precision) {
        OrientedPoint maxBoundary;
        Interval.validateIntervalValues(a, b);
        double min = Math.min(a, b);
        double max = Math.max(a, b);
        OrientedPoint minBoundary = Double.isFinite(min) ? OrientedPoints.fromLocationAndDirection(min, false, precision) : null;
        OrientedPoint orientedPoint = maxBoundary = Double.isFinite(max) ? OrientedPoints.fromLocationAndDirection(max, true, precision) : null;
        if (minBoundary == null && maxBoundary == null) {
            return FULL;
        }
        return new Interval(minBoundary, maxBoundary);
    }

    public static Interval of(Vector1D a, Vector1D b, Precision.DoubleEquivalence precision) {
        return Interval.of(a.getX(), b.getX(), precision);
    }

    public static Interval of(OrientedPoint a, OrientedPoint b) {
        boolean hasB;
        Interval.validateBoundaryRelationship(a, b);
        boolean hasA = a != null;
        boolean bl = hasB = b != null;
        if (!hasA && !hasB) {
            return FULL;
        }
        OrientedPoint minBoundary = hasA && !a.isPositiveFacing() || hasB && b.isPositiveFacing() ? a : b;
        OrientedPoint maxBoundary = hasA && a.isPositiveFacing() || hasB && !b.isPositiveFacing() ? a : b;
        double minLoc = minBoundary != null ? minBoundary.getLocation() : Double.NEGATIVE_INFINITY;
        double maxLoc = maxBoundary != null ? maxBoundary.getLocation() : Double.POSITIVE_INFINITY;
        Interval.validateIntervalValues(minLoc, maxLoc);
        return new Interval(Double.isFinite(minLoc) ? minBoundary : null, Double.isFinite(maxLoc) ? maxBoundary : null);
    }

    public static Interval min(double min, Precision.DoubleEquivalence precision) {
        return Interval.of(min, Double.POSITIVE_INFINITY, precision);
    }

    public static Interval max(double max, Precision.DoubleEquivalence precision) {
        return Interval.of(Double.NEGATIVE_INFINITY, max, precision);
    }

    public static Interval point(double location, Precision.DoubleEquivalence precision) {
        return Interval.of(location, location, precision);
    }

    public static Interval full() {
        return FULL;
    }

    private static void validateBoundaryRelationship(OrientedPoint a, OrientedPoint b) {
        if (a != null && b != null) {
            if (a.isPositiveFacing() == b.isPositiveFacing()) {
                throw new IllegalArgumentException(MessageFormat.format("Invalid interval: hyperplanes have same orientation: {0}, {1}", new Object[]{a, b}));
            }
            if (a.classify(b.getPoint()) == HyperplaneLocation.PLUS || b.classify(a.getPoint()) == HyperplaneLocation.PLUS) {
                throw new IllegalArgumentException(MessageFormat.format("Invalid interval: hyperplanes do not form interval: {0}, {1}", new Object[]{a, b}));
            }
        }
    }

    private static void validateIntervalValues(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) && Double.compare(a, b) == 0) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid interval values: [{0}, {1}]", a, b));
        }
    }
}

