/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.commons.geometry.euclidean.twod.BoundarySource2D;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;

final class BoundarySourceBoundsBuilder2D {
    BoundarySourceBoundsBuilder2D() {
    }

    public Bounds2D getBounds(BoundarySource2D src) {
        Bounds2D.Builder builder = Bounds2D.builder();
        try (Stream stream = src.boundaryStream();){
            Iterator it = stream.iterator();
            while (it.hasNext()) {
                LineConvexSubset boundary = (LineConvexSubset)it.next();
                if (boundary.isInfinite()) {
                    Bounds2D bounds2D = null;
                    return bounds2D;
                }
                builder.add(boundary.getStartPoint());
                builder.add(boundary.getEndPoint());
            }
        }
        return builder.hasBounds() ? builder.build() : null;
    }
}

