/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning.bsp;

import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;

public abstract class AbstractBSPTreeMergeOperator<P extends Point<P>, N extends AbstractBSPTree.AbstractNode<P, N>> {
    private AbstractBSPTree<P, N> outputTree;

    protected void setOutputTree(AbstractBSPTree<P, N> outputTree) {
        this.outputTree = outputTree;
    }

    protected AbstractBSPTree<P, N> getOutputTree() {
        return this.outputTree;
    }

    protected void performMerge(AbstractBSPTree<P, N> input1, AbstractBSPTree<P, N> input2, AbstractBSPTree<P, N> output) {
        this.setOutputTree(output);
        BSPTree.Node root1 = input1.getRoot();
        BSPTree.Node root2 = input2.getRoot();
        BSPTree.Node outputRoot = this.performMergeRecursive(root1, root2);
        this.getOutputTree().setRoot(outputRoot);
    }

    private N performMergeRecursive(N node1, N node2) {
        if (((AbstractBSPTree.AbstractNode)node1).isLeaf() || ((AbstractBSPTree.AbstractNode)node2).isLeaf()) {
            N merged = this.mergeLeaf(node1, node2);
            return this.outputTree.importSubtree(merged);
        }
        N partitioned = this.outputTree.splitSubtree(node2, ((AbstractBSPTree.AbstractNode)node1).getCut());
        BSPTree.Node minus = this.performMergeRecursive(((AbstractBSPTree.AbstractNode)node1).getMinus(), ((AbstractBSPTree.AbstractNode)partitioned).getMinus());
        BSPTree.Node plus = this.performMergeRecursive(((AbstractBSPTree.AbstractNode)node1).getPlus(), ((AbstractBSPTree.AbstractNode)partitioned).getPlus());
        BSPTree.Node outputNode = this.outputTree.copyNode(node1);
        ((AbstractBSPTree.AbstractNode)outputNode).setSubtree(((AbstractBSPTree.AbstractNode)node1).getCut(), (BSPTree.Node)minus, (BSPTree.Node)plus);
        return (N)outputNode;
    }

    protected N outputNode() {
        return this.outputTree.createNode();
    }

    protected N outputSubtree(N node) {
        return this.outputTree.importSubtree(node);
    }

    protected abstract N mergeLeaf(N var1, N var2);
}

