/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.png.AbstractPngTest;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConvertPngToGifTest
extends AbstractPngTest {
    @Test
    public void test() throws Exception {
        List<File> images = this.getPngImages();
        for (File imageFile : images) {
            if (this.isInvalidPngTestFile(imageFile)) continue;
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            Assertions.assertNotNull((Object)image);
            File outFile = Files.createTempFile(imageFile.getName() + ".", ".gif", new FileAttribute[0]).toFile();
            Imaging.writeImage((BufferedImage)image, (File)outFile, (ImageFormat)ImageFormats.GIF);
        }
        Debug.debug((String)"complete.");
    }
}

