/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Random;
import org.apache.commons.imaging.AbstractImagingTest;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.GenericImageMetadata;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.png.AbstractPngText;
import org.apache.commons.imaging.formats.png.PhysicalScale;
import org.apache.commons.imaging.formats.png.PngImageInfo;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngWriteReadTest
extends AbstractImagingTest {
    private int[][] bufferedImageToImageData(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] result = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = image.getRGB(x, y);
            }
        }
        return result;
    }

    private int[][] getAscendingRawData(int width, int height) {
        int[][] result = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb;
                int alpha = (x + y) % 256;
                int value = (x + y) % 256;
                result[y][x] = argb = (0xFF & alpha) << 24 | (0xFF & value) << 16 | (0xFF & value) << 8 | (0xFF & value) << 0;
            }
        }
        return result;
    }

    private int[][] getSimpleRawData(int width, int height, int value) {
        int[][] result = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = value;
            }
        }
        return result;
    }

    private BufferedImage imageDataToBufferedImage(int[][] rawData) {
        int width = rawData[0].length;
        int height = rawData.length;
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image.setRGB(x, y, rawData[y][x]);
            }
        }
        return image;
    }

    private int[][] randomRawData(int width, int height) {
        Random random = new Random();
        int[][] result = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb;
                result[y][x] = argb = random.nextInt();
            }
        }
        return result;
    }

    @Test
    public void test() throws Exception {
        int[][][] testData;
        int[][] smallBlackPixels = this.getSimpleRawData(256, 256, 0);
        int[][] singleBlackPixel = this.getSimpleRawData(1, 1, 0);
        int[][] smallRedPixels = this.getSimpleRawData(256, 256, -65536);
        int[][] singleRedPixel = this.getSimpleRawData(1, 1, -65536);
        int[][] smallAscendingPixels = this.getAscendingRawData(256, 256);
        int[][] smallRandomPixels = this.randomRawData(256, 256);
        for (int[][] rawData : testData = new int[][][]{smallBlackPixels, singleBlackPixel, smallRedPixels, singleRedPixel, smallAscendingPixels, smallRandomPixels}) {
            this.writeAndReadImageData(rawData);
        }
    }

    @Test
    public void testMultipletEXt() throws Exception {
        int[][] smallBlackPixels = this.getSimpleRawData(256, 256, 0);
        this.writeAndReadMultipleEXt(smallBlackPixels);
    }

    @Test
    public void testPhysicalScaleMeters() throws Exception {
        byte[] pngBytes;
        PngImageParser pngImageParser = new PngImageParser();
        PngImagingParameters optionalParams = new PngImagingParameters();
        optionalParams.setPhysicalScale(PhysicalScale.createFromMeters((double)0.01, (double)0.02));
        int[][] smallAscendingPixels = this.getAscendingRawData(256, 256);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            pngImageParser.writeImage(this.imageDataToBufferedImage(smallAscendingPixels), (OutputStream)baos, optionalParams);
            pngBytes = baos.toByteArray();
        }
        PngImageInfo imageInfo = (PngImageInfo)Imaging.getImageInfo((byte[])pngBytes);
        PhysicalScale physicalScale = imageInfo.getPhysicalScale();
        Assertions.assertTrue((boolean)physicalScale.isInMeters());
        Assertions.assertEquals((double)0.01, (double)physicalScale.getHorizontalUnitsPerPixel(), (double)0.001);
        Assertions.assertEquals((double)0.02, (double)physicalScale.getVerticalUnitsPerPixel(), (double)0.001);
    }

    @Test
    public void testPhysicalScaleRadians() throws Exception {
        byte[] pngBytes;
        PngImageParser pngImageParser = new PngImageParser();
        PngImagingParameters optionalParams = new PngImagingParameters();
        optionalParams.setPhysicalScale(PhysicalScale.createFromRadians((double)0.01, (double)0.02));
        int[][] smallAscendingPixels = this.getAscendingRawData(256, 256);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            pngImageParser.writeImage(this.imageDataToBufferedImage(smallAscendingPixels), (OutputStream)baos, optionalParams);
            pngBytes = baos.toByteArray();
        }
        PngImageInfo imageInfo = (PngImageInfo)Imaging.getImageInfo((byte[])pngBytes);
        PhysicalScale physicalScale = imageInfo.getPhysicalScale();
        Assertions.assertTrue((boolean)physicalScale.isInRadians());
        Assertions.assertEquals((double)0.01, (double)physicalScale.getHorizontalUnitsPerPixel(), (double)0.001);
        Assertions.assertEquals((double)0.02, (double)physicalScale.getVerticalUnitsPerPixel(), (double)0.001);
    }

    @Test
    public void testTransparency() throws Exception {
        int[][] smallAscendingPixels = this.getAscendingRawData(256, 256);
        byte[] pngBytes = Imaging.writeImageToBytes((BufferedImage)this.imageDataToBufferedImage(smallAscendingPixels), (ImageFormat)ImageFormats.PNG);
        Assertions.assertTrue((boolean)Imaging.getImageInfo((byte[])pngBytes).isTransparent());
    }

    private void writeAndReadImageData(int[][] rawData) throws IOException, ImagingException, ImagingException {
        BufferedImage srcImage = this.imageDataToBufferedImage(rawData);
        byte[] bytes = Imaging.writeImageToBytes((BufferedImage)srcImage, (ImageFormat)ImageFormats.PNG);
        BufferedImage dstImage = Imaging.getBufferedImage((byte[])bytes);
        Assertions.assertNotNull((Object)dstImage);
        Assertions.assertEquals((int)srcImage.getWidth(), (int)dstImage.getWidth());
        Assertions.assertEquals((int)srcImage.getHeight(), (int)dstImage.getHeight());
        int[][] dstData = this.bufferedImageToImageData(dstImage);
        Assertions.assertArrayEquals((Object[])rawData, (Object[])dstData);
    }

    private void writeAndReadMultipleEXt(int[][] rawData) throws IOException, ImagingException, ImagingException {
        byte[] bytes;
        BufferedImage srcImage = this.imageDataToBufferedImage(rawData);
        LinkedList<AbstractPngText.Text> textChunks = new LinkedList<AbstractPngText.Text>();
        textChunks.add(new AbstractPngText.Text("a", "b"));
        textChunks.add(new AbstractPngText.Text("c", "d"));
        PngImagingParameters writeParams = new PngImagingParameters();
        writeParams.setTextChunks(textChunks);
        PngImageParser pngImageParser = new PngImageParser();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            pngImageParser.writeImage(srcImage, (OutputStream)os, writeParams);
            bytes = os.toByteArray();
        }
        BufferedImage dstImage = Imaging.getBufferedImage((byte[])bytes);
        Assertions.assertNotNull((Object)dstImage);
        Assertions.assertEquals((int)srcImage.getWidth(), (int)dstImage.getWidth());
        Assertions.assertEquals((int)srcImage.getHeight(), (int)dstImage.getHeight());
        int[][] dstData = this.bufferedImageToImageData(dstImage);
        Assertions.assertArrayEquals((Object[])rawData, (Object[])dstData);
        ImageMetadata imageMetadata = Imaging.getMetadata((byte[])bytes);
        Assertions.assertEquals((int)imageMetadata.getItems().size(), (int)2);
        GenericImageMetadata.GenericImageMetadataItem item0 = (GenericImageMetadata.GenericImageMetadataItem)imageMetadata.getItems().get(0);
        Assertions.assertEquals((Object)item0.getKeyword(), (Object)"a");
        Assertions.assertEquals((Object)item0.getText(), (Object)"b");
        GenericImageMetadata.GenericImageMetadataItem item1 = (GenericImageMetadata.GenericImageMetadataItem)imageMetadata.getItems().get(1);
        Assertions.assertEquals((Object)item1.getKeyword(), (Object)"c");
        Assertions.assertEquals((Object)item1.getText(), (Object)"d");
    }
}

