/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.nio.ByteOrder;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeAscii;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FieldTypeAsciiTest {
    @Test
    public void testCreatesFieldTypeAsciiAndCallsWriteData() {
        FieldTypeAscii fieldTypeAscii = new FieldTypeAscii(0, "1\u007f");
        byte[] byteArray = new byte[1];
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        TiffField tiffField = new TiffField(0, 0, (AbstractFieldType)fieldTypeAscii, 0L, 0L, byteArray, byteOrder, 1);
        Assertions.assertThrows(ImagingException.class, () -> fieldTypeAscii.writeData((Object)tiffField, byteOrder));
    }

    @Test
    public void testCreatesFieldTypeAsciiAndWriteDataUsingByteArray() throws ImagingException {
        FieldTypeAscii fieldTypeAscii = new FieldTypeAscii(0, "1");
        byte[] byteArray = new byte[1];
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        byte[] byteArrayTwo = fieldTypeAscii.writeData((Object)byteArray, byteOrder);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0}, (byte[])byteArrayTwo);
    }

    @Test
    public void testCreatesFieldTypeAsciiAndWriteDataUsingString() throws ImagingException {
        FieldTypeAscii fieldTypeAscii = new FieldTypeAscii(0, "1");
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        byte[] byteArrayTwo = fieldTypeAscii.writeData((Object)"asdf", byteOrder);
        Assertions.assertArrayEquals((byte[])new byte[]{97, 115, 100, 102, 0}, (byte[])byteArrayTwo);
    }
}

