/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;

public final class GarbageCollectionHelper
implements Closeable,
Runnable {
    private static final OutputStream SINK = new OutputStream(){

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }
    };
    private final AtomicBoolean running = new AtomicBoolean();
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Thread gcThread = new Thread(new GcTask());

    @Override
    public void close() {
        this.running.set(false);
        try {
            TestCase.assertTrue((String)"GarbageCollectionHelper did not shut down cleanly", (boolean)this.latch.await(10L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        if (this.running.compareAndSet(false, true)) {
            this.gcThread.start();
        }
    }

    final class GcTask
    implements Runnable {
        GcTask() {
        }

        @Override
        public void run() {
            try {
                while (GarbageCollectionHelper.this.running.get()) {
                    try {
                        byte[] buf = new byte[0x100000];
                        SINK.write(buf);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    System.gc();
                }
            }
            finally {
                GarbageCollectionHelper.this.latch.countDown();
            }
        }
    }
}

