/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet;

import java.util.HashSet;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializerFactory;
import org.apache.commons.math3.ml.neuralnet.MapUtils;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.OffsetFeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.oned.NeuronString;
import org.junit.Assert;
import org.junit.Test;

public class MapUtilsTest {
    @Test
    public void testFindClosestNeuron() {
        double[][] features;
        OffsetFeatureInitializer init = new OffsetFeatureInitializer(FeatureInitializerFactory.uniform((double)-0.1, (double)0.1));
        FeatureInitializer[] initArray = new FeatureInitializer[]{init};
        Network net = new NeuronString(3, false, initArray).getNetwork();
        EuclideanDistance dist = new EuclideanDistance();
        HashSet allBest = new HashSet();
        HashSet<Neuron> best = new HashSet<Neuron>();
        best.clear();
        for (double[] f : features = new double[][]{{-1.0}, {0.4}}) {
            best.add(MapUtils.findBest((double[])f, (Iterable)net, (DistanceMeasure)dist));
        }
        Assert.assertEquals((long)1L, (long)best.size());
        allBest.addAll(best);
        best.clear();
        for (double[] f : features = new double[][]{{0.6}, {1.4}}) {
            best.add(MapUtils.findBest((double[])f, (Iterable)net, (DistanceMeasure)dist));
        }
        Assert.assertEquals((long)1L, (long)best.size());
        allBest.addAll(best);
        best.clear();
        for (double[] f : features = new double[][]{{1.6}, {3.0}}) {
            best.add(MapUtils.findBest((double[])f, (Iterable)net, (DistanceMeasure)dist));
        }
        Assert.assertEquals((long)1L, (long)best.size());
        allBest.addAll(best);
        Assert.assertEquals((long)3L, (long)allBest.size());
    }

    @Test
    public void testSort() {
        HashSet<Neuron> list = new HashSet<Neuron>();
        for (int i = 0; i < 4; ++i) {
            list.add(new Neuron((long)i, new double[]{(double)i - 0.5}));
        }
        Neuron[] sorted = MapUtils.sort((double[])new double[]{3.4}, list, (DistanceMeasure)new EuclideanDistance());
        long[] expected = new long[]{3L, 2L, 1L, 0L};
        for (int i = 0; i < list.size(); ++i) {
            Assert.assertEquals((long)expected[i], (long)sorted[i].getIdentifier());
        }
    }
}

