/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.distribution;

import org.apache.commons.math4.legacy.distribution.MultivariateRealDistribution;
import org.apache.commons.math4.legacy.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.rng.UniformRandomProvider;

public abstract class AbstractMultivariateRealDistribution
implements MultivariateRealDistribution {
    private final int dimension;

    protected AbstractMultivariateRealDistribution(int n) {
        this.dimension = n;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public abstract MultivariateRealDistribution.Sampler createSampler(UniformRandomProvider var1);

    public static double[][] sample(int n, MultivariateRealDistribution.Sampler sampler) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, (Number)n);
        }
        double[][] samples = new double[n][];
        for (int i = 0; i < n; ++i) {
            samples[i] = sampler.sample();
        }
        return samples;
    }
}

