/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ml.clustering.evaluation;

import java.util.List;
import org.apache.commons.math4.legacy.ml.clustering.Cluster;
import org.apache.commons.math4.legacy.ml.clustering.ClusterEvaluator;
import org.apache.commons.math4.legacy.ml.clustering.Clusterable;
import org.apache.commons.math4.legacy.ml.distance.DistanceMeasure;
import org.apache.commons.math4.legacy.stat.descriptive.moment.Variance;

public class SumOfClusterVariances
implements ClusterEvaluator {
    private final DistanceMeasure measure;

    public SumOfClusterVariances(DistanceMeasure measure) {
        this.measure = measure;
    }

    @Override
    public double score(List<? extends Cluster<? extends Clusterable>> clusters) {
        double varianceSum = 0.0;
        for (Cluster<? extends Clusterable> cluster : clusters) {
            if (cluster.getPoints().isEmpty()) continue;
            Clusterable center = cluster.centroid();
            Variance stat = new Variance();
            for (Clusterable clusterable : cluster.getPoints()) {
                stat.increment(this.distance(clusterable, center));
            }
            varianceSum += stat.getResult();
        }
        return varianceSum;
    }

    @Override
    public boolean isBetterScore(double a, double b) {
        return a < b;
    }

    private double distance(Clusterable p1, Clusterable p2) {
        return this.measure.compute(p1.getPoint(), p2.getPoint());
    }
}

