/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.legacy.optim.AbstractConvergenceChecker;
import org.apache.commons.math4.legacy.optim.PointValuePair;

public class SimpleValueChecker
extends AbstractConvergenceChecker<PointValuePair> {
    private static final int ITERATION_CHECK_DISABLED = -1;
    private final int maxIterationCount;

    public SimpleValueChecker(double relativeThreshold, double absoluteThreshold) {
        super(relativeThreshold, absoluteThreshold);
        this.maxIterationCount = -1;
    }

    public SimpleValueChecker(double relativeThreshold, double absoluteThreshold, int maxIter) {
        super(relativeThreshold, absoluteThreshold);
        if (maxIter <= 0) {
            throw new NotStrictlyPositiveException((Number)maxIter);
        }
        this.maxIterationCount = maxIter;
    }

    @Override
    public boolean converged(int iteration, PointValuePair previous, PointValuePair current) {
        double size;
        double c;
        if (this.maxIterationCount != -1 && iteration >= this.maxIterationCount) {
            return true;
        }
        double p = (Double)previous.getValue();
        double difference = JdkMath.abs((double)(p - (c = ((Double)current.getValue()).doubleValue())));
        return difference <= (size = JdkMath.max((double)JdkMath.abs((double)p), (double)JdkMath.abs((double)c))) * this.getRelativeThreshold() || difference <= this.getAbsoluteThreshold();
    }
}

