/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.transform;

import java.util.function.UnaryOperator;
import org.apache.commons.math4.transform.RealTransform;
import org.apache.commons.math4.transform.TransformException;
import org.apache.commons.math4.transform.TransformUtils;
import org.apache.commons.numbers.core.ArithmeticUtils;

public class FastHadamardTransform
implements RealTransform {
    private final UnaryOperator<double[]> op;

    public FastHadamardTransform() {
        this(false);
    }

    public FastHadamardTransform(boolean inverse) {
        this.op = this.create(inverse);
    }

    @Override
    public double[] apply(double[] f) {
        return (double[])this.op.apply(f);
    }

    @Override
    public int[] apply(int[] f) {
        return this.fht(f);
    }

    private double[] fht(double[] x) {
        int n = x.length;
        if (!ArithmeticUtils.isPowerOfTwo((long)n)) {
            throw new TransformException("{0} is not equal to pow(2, n), for some n", n);
        }
        int halfN = n / 2;
        double[] yPrevious = new double[n];
        double[] yCurrent = (double[])x.clone();
        for (int j = 1; j < n; j <<= 1) {
            int twoI;
            int i;
            double[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i = 0; i < halfN; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i = halfN; i < n; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI - n] - yPrevious[twoI - n + 1];
            }
        }
        return yCurrent;
    }

    private int[] fht(int[] x) {
        int n = x.length;
        if (!ArithmeticUtils.isPowerOfTwo((long)n)) {
            throw new TransformException("{0} is not equal to pow(2, n), for some n", n);
        }
        int halfN = n / 2;
        int[] yPrevious = new int[n];
        int[] yCurrent = (int[])x.clone();
        for (int j = 1; j < n; j <<= 1) {
            int twoI;
            int i;
            int[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i = 0; i < halfN; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i = halfN; i < n; ++i) {
                twoI = 2 * i;
                yCurrent[i] = yPrevious[twoI - n] - yPrevious[twoI - n + 1];
            }
        }
        return yCurrent;
    }

    private UnaryOperator<double[]> create(boolean inverse) {
        if (inverse) {
            return f -> TransformUtils.scaleInPlace(this.fht((double[])f), 1.0 / (double)((double[])f).length);
        }
        return f -> this.fht((double[])f);
    }
}

