/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.commandline;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli.Converter;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rat.ConfigurationException;
import org.apache.rat.document.DocumentName;
import org.apache.rat.report.claim.ClaimStatistic;

public final class Converters {
    public static final FileConverter FILE_CONVERTER = new FileConverter();
    public static final Converter<Pair<ClaimStatistic.Counter, Integer>, ConfigurationException> COUNTER_CONVERTER = arg -> {
        String[] parts = arg.split(":");
        try {
            ClaimStatistic.Counter counter = ClaimStatistic.Counter.valueOf(parts[0].toUpperCase());
            Integer limit = Integer.parseInt(parts[1]);
            return Pair.of(counter, limit);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("'%s' is not a valid integer", parts[1]), e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("'%s' is not a valid Counter", parts[0]), e);
        }
    };
    public static final Converter<String[], ConfigurationException> TEXT_LIST_CONVERTER = arg -> {
        if (arg == null) {
            return null;
        }
        return (String[])Arrays.stream(arg.split(",")).map(String::trim).toArray(String[]::new);
    };

    private Converters() {
    }

    public static final class FileConverter
    implements Converter<File, NullPointerException> {
        private DocumentName workingDirectory;

        private FileConverter() {
        }

        public void setWorkingDirectory(DocumentName workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public File apply(String fileName) throws NullPointerException {
            File file = new File(fileName);
            if (!fileName.startsWith(File.separator) && !DocumentName.FSInfo.getDefault().rootFor(fileName).isPresent()) {
                file = new File(this.workingDirectory.resolve(fileName).getName()).getAbsoluteFile();
            }
            try {
                return file.getCanonicalFile();
            }
            catch (IOException e) {
                return file.getAbsoluteFile();
            }
        }
    }
}

