/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListOfFilesFilter
implements FileFilter {
    private List<String> listOfFiles;

    ListOfFilesFilter(String ... files) {
        this.listOfFiles = Arrays.asList(files);
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return false;
        }
        return this.listOfFiles.contains(pathname.getName().toLowerCase());
    }

    public List<String> getListOfFiles() {
        return Collections.unmodifiableList(this.listOfFiles);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Filtering for one of the following file names [");
        builder.append(this.listOfFiles);
        builder.append("]");
        return builder.toString();
    }
}

