/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.attachment.wsdl11;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.AbstractDescriptionElement;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.DescriptionInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.Extensible;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.policy.attachment.AbstractPolicyProvider;
import org.apache.cxf.ws.policy.attachment.reference.LocalServiceModelReferenceResolver;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@NoJSR250Annotations
public class Wsdl11AttachmentPolicyProvider
extends AbstractPolicyProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(Wsdl11AttachmentPolicyProvider.class);

    public Wsdl11AttachmentPolicyProvider() {
        this(null);
    }

    public Wsdl11AttachmentPolicyProvider(Bus bus) {
        super(bus);
    }

    @Override
    public Policy getEffectivePolicy(ServiceInfo si, Message m) {
        return this.getElementPolicy((AbstractDescriptionElement)si);
    }

    private Policy mergePolicies(Policy p1, Policy p2) {
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        return p1.merge(p2);
    }

    @Override
    public Policy getEffectivePolicy(EndpointInfo ei, Message m) {
        Policy p = this.getElementPolicy((AbstractDescriptionElement)ei);
        p = this.mergePolicies(p, this.getElementPolicy((AbstractDescriptionElement)ei.getBinding()));
        p = this.mergePolicies(p, this.getElementPolicy((AbstractDescriptionElement)ei.getInterface(), true));
        return p;
    }

    @Override
    public Policy getEffectivePolicy(BindingOperationInfo bi, Message m) {
        DescriptionInfo di = bi.getBinding().getDescription();
        Policy p = this.getElementPolicy((Extensible)bi, false, di);
        p = this.mergePolicies(p, this.getElementPolicy((Extensible)bi.getOperationInfo(), false, di));
        return p;
    }

    @Override
    public Policy getEffectivePolicy(BindingMessageInfo bmi, Message m) {
        ServiceInfo si = bmi.getBindingOperation().getBinding().getService();
        DescriptionInfo di = si.getDescription();
        Policy p = this.getElementPolicy((Extensible)bmi, false, di);
        MessageInfo mi = bmi.getMessageInfo();
        p = this.mergePolicies(p, this.getElementPolicy((Extensible)mi, true, di));
        Extensible ex = this.getMessageTypeInfo(mi.getName(), di);
        p = this.mergePolicies(p, this.getElementPolicy(ex, false, di));
        return p;
    }

    @Override
    public Policy getEffectivePolicy(BindingFaultInfo bfi, Message m) {
        ServiceInfo si = bfi.getBindingOperation().getBinding().getService();
        DescriptionInfo di = si.getDescription();
        Policy p = this.getElementPolicy((Extensible)bfi, false, di);
        FaultInfo fi = bfi.getFaultInfo();
        p = this.mergePolicies(p, this.getElementPolicy((Extensible)fi, true, di));
        Extensible ex = this.getMessageTypeInfo(fi.getName(), di);
        p = this.mergePolicies(p, this.getElementPolicy(ex, false, di));
        return p;
    }

    Policy getElementPolicy(AbstractDescriptionElement adh) {
        return this.getElementPolicy(adh, false);
    }

    Policy getElementPolicy(AbstractDescriptionElement adh, boolean includeAttributes) {
        if (adh == null) {
            return null;
        }
        return this.getElementPolicy((Extensible)adh, includeAttributes, adh.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Policy getElementPolicy(Extensible ex, boolean includeAttributes, DescriptionInfo di) {
        Object uri;
        if (null == ex || null == di) {
            return null;
        }
        DescriptionInfo descriptionInfo = di;
        synchronized (descriptionInfo) {
            if (di.getProperty("registeredPolicy") == null) {
                List diext = di.getExtensors(UnknownExtensibilityElement.class);
                if (diext != null) {
                    for (UnknownExtensibilityElement unknownExtensibilityElement : diext) {
                        Element element = unknownExtensibilityElement.getElement();
                        Document document = element.getOwnerDocument();
                        synchronized (document) {
                            String id;
                            Policy policy;
                            uri = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                            if (Constants.isPolicyElement((QName)unknownExtensibilityElement.getElementType()) && !StringUtils.isEmpty((String)uri) && (policy = this.registry.lookup(id = (di.getBaseURI() == null ? Integer.toString(di.hashCode()) : di.getBaseURI()) + "#" + (String)uri)) == null) {
                                try {
                                    policy = this.builder.getPolicy(element);
                                    String fragement = "#" + (String)uri;
                                    this.registry.register(fragement, policy);
                                    this.registry.register(id, policy);
                                }
                                catch (Exception policyEx) {
                                    LOG.warning("Failed to build the policy '" + (String)uri + "':" + policyEx.getMessage());
                                }
                            }
                        }
                    }
                }
                di.setProperty("registeredPolicy", (Object)true);
            }
        }
        Policy elementPolicy = null;
        List extensions = ex.getExtensors(UnknownExtensibilityElement.class);
        if (null != extensions) {
            for (UnknownExtensibilityElement unknownExtensibilityElement : extensions) {
                Policy p = null;
                Element element = unknownExtensibilityElement.getElement();
                uri = element.getOwnerDocument();
                synchronized (uri) {
                    PolicyReference ref;
                    if (Constants.isPolicyElement((QName)unknownExtensibilityElement.getElementType())) {
                        p = this.builder.getPolicy(element);
                    } else if (Constants.isPolicyRef((QName)unknownExtensibilityElement.getElementType()) && null != (ref = this.builder.getPolicyReference(element))) {
                        p = this.resolveReference(ref, di);
                    }
                }
                if (null == p) continue;
                if (elementPolicy == null) {
                    elementPolicy = new Policy();
                }
                elementPolicy = elementPolicy.merge(p);
            }
        }
        if (includeAttributes && ex.getExtensionAttributes() != null) {
            for (Map.Entry entry : ex.getExtensionAttributes().entrySet()) {
                if (!Constants.isPolicyURIsAttr((QName)((QName)entry.getKey()))) continue;
                Object attr = entry.getValue();
                String uris = null;
                if (attr instanceof QName) {
                    uris = ((QName)attr).getLocalPart();
                } else if (attr instanceof String) {
                    uris = (String)attr;
                }
                if (null == uris) continue;
                StringTokenizer st = new StringTokenizer(uris);
                while (st.hasMoreTokens()) {
                    String uri2 = st.nextToken();
                    PolicyReference ref = new PolicyReference();
                    ref.setURI(uri2);
                    Policy p = this.resolveReference(ref, di);
                    if (null == p) continue;
                    elementPolicy = elementPolicy == null ? new Policy().merge(p) : elementPolicy.merge(p);
                }
            }
        }
        return elementPolicy;
    }

    Policy resolveReference(PolicyReference ref, DescriptionInfo di) {
        Policy p;
        if (this.isExternal(ref)) {
            String uri = di.getBaseURI();
            if (uri == null) {
                uri = Integer.toString(di.hashCode());
            }
            p = this.resolveExternal(ref, uri);
        } else {
            p = this.resolveLocal(ref, di);
        }
        this.checkResolved(ref, p);
        return p;
    }

    Policy resolveLocal(PolicyReference ref, DescriptionInfo di) {
        String uri = ref.getURI().substring(1);
        String absoluteURI = di.getBaseURI();
        absoluteURI = absoluteURI == null ? Integer.toString(di.hashCode()) + ref.getURI() : absoluteURI + ref.getURI();
        Policy resolved = this.registry.lookup(absoluteURI);
        if (null != resolved) {
            return resolved;
        }
        LocalServiceModelReferenceResolver resolver = new LocalServiceModelReferenceResolver(di, this.builder);
        resolved = resolver.resolveReference(uri);
        if (null != resolved) {
            ref.setURI(absoluteURI);
            this.registry.register(absoluteURI, resolved);
        }
        return resolved;
    }

    private Extensible getMessageTypeInfo(QName name, DescriptionInfo di) {
        List extensors;
        if (null == di) {
            return null;
        }
        Definition def = (Definition)di.getProperty("org.apache.cxf.wsdl11.WSDLServiceBuilder.DEFINITION");
        if (null == def) {
            return null;
        }
        javax.wsdl.Message m = def.getMessage(name);
        if (null != m && null != (extensors = CastUtils.cast((List)m.getExtensibilityElements(), ExtensibilityElement.class))) {
            return new ExtensibleInfo(extensors);
        }
        return null;
    }

    private static class ExtensibleInfo
    implements Extensible {
        private List<ExtensibilityElement> extensors;

        ExtensibleInfo(List<ExtensibilityElement> e) {
            this.extensors = e;
        }

        public <T> T getExtensor(Class<T> cls) {
            for (ExtensibilityElement e : this.extensors) {
                if (!cls.isInstance(e)) continue;
                return cls.cast(e);
            }
            return null;
        }

        public <T> List<T> getExtensors(Class<T> cls) {
            if (null == this.extensors) {
                return null;
            }
            ArrayList<T> list = new ArrayList<T>(this.extensors.size());
            for (ExtensibilityElement e : this.extensors) {
                if (!cls.isInstance(e)) continue;
                list.add(cls.cast(e));
            }
            return list;
        }

        public void addExtensionAttribute(QName arg0, Object arg1) {
        }

        public void addExtensor(Object arg0) {
        }

        public Object getExtensionAttribute(QName arg0) {
            return null;
        }

        public Map<QName, Object> getExtensionAttributes() {
            return null;
        }

        public void setExtensionAttributes(Map<QName, Object> arg0) {
        }
    }
}

