/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cxf.tools.corba.processors.idl.Scope;

public class ModuleToNSMapper {
    Map<String, String> userMap = new HashMap<String, String>();
    Map<String, List<String>> exModules = new HashMap<String, List<String>>();
    boolean defaultMapping = true;

    public void setDefaultMapping(boolean flag) {
        this.defaultMapping = flag;
    }

    public boolean isDefaultMapping() {
        return this.defaultMapping;
    }

    public void setUserMapping(Map<String, String> map) {
        this.userMap = map;
    }

    public Map<String, String> getUserMapping() {
        return this.userMap;
    }

    public void setExcludedModuleMap(Map<String, List<String>> map) {
        this.exModules = map;
    }

    public Map<String, List<String>> getExcludedModuleMap() {
        return this.exModules;
    }

    public Iterator<String> getExcludedModules() {
        return this.exModules.keySet().iterator();
    }

    public List<String> getExcludedImports(String module) {
        return this.exModules.get(module);
    }

    public boolean containsExcludedModule(String module) {
        return this.exModules.containsKey(module);
    }

    public String map(String scopeStr, String separator) {
        Scope scope = new Scope(scopeStr, separator);
        return this.map(scope);
    }

    public String map(Scope scope) {
        return this.map(scope, "::");
    }

    public String map(Scope scope, String separator) {
        if (this.defaultMapping) {
            return null;
        }
        String uri = this.userMap.get(scope.toString(separator));
        if (uri == null) {
            String parentURI = null;
            uri = "";
            for (Scope currentScope = scope; parentURI == null && !currentScope.toString().isEmpty() && currentScope != currentScope.getParent(); currentScope = currentScope.getParent()) {
                parentURI = this.userMap.get(currentScope.toString(separator));
                if (parentURI != null) continue;
                if (!"".equals(uri)) {
                    uri = "/" + uri;
                }
                uri = currentScope.tail() + uri;
            }
            if (parentURI != null) {
                if (!parentURI.endsWith("/")) {
                    parentURI = parentURI + "/";
                }
                uri = parentURI + uri;
            } else {
                uri = "urn:" + uri;
            }
        }
        return uri;
    }

    public String mapToQName(Scope scope) {
        if (this.defaultMapping) {
            return scope.toString();
        }
        return scope.tail();
    }

    public String mapNSToPrefix(String nsURI) {
        int pos = nsURI.indexOf(58);
        if (pos != -1) {
            nsURI = nsURI.substring(pos + 1);
        }
        return nsURI.replaceAll("/", "_");
    }
}

