/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.wildfly.common.Assert;
import org.xnio.ChannelListener;
import org.xnio.ChannelPipe;
import org.xnio.FailedIoFuture;
import org.xnio.IoFuture;
import org.xnio.LocalSocketAddress;
import org.xnio.MessageConnection;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoFactory;
import org.xnio.XnioWorker;
import org.xnio._private.Messages;
import org.xnio.channels.AssembledStreamChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.StreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class XnioIoThread
extends Thread
implements XnioExecutor,
XnioIoFactory {
    private static final InetSocketAddress ANY_INET_ADDRESS = new InetSocketAddress(0);
    private final XnioWorker worker;
    private final int number;

    protected XnioIoThread(XnioWorker worker, int number) {
        this.number = number;
        this.worker = worker;
    }

    protected XnioIoThread(XnioWorker worker, int number, String name) {
        super(name);
        this.number = number;
        this.worker = worker;
    }

    protected XnioIoThread(XnioWorker worker, int number, ThreadGroup group, String name) {
        super(group, name);
        this.number = number;
        this.worker = worker;
    }

    protected XnioIoThread(XnioWorker worker, int number, ThreadGroup group, String name, long stackSize) {
        super(group, null, name, stackSize);
        this.number = number;
        this.worker = worker;
    }

    public static XnioIoThread currentThread() {
        Thread thread = Thread.currentThread();
        if (thread instanceof XnioIoThread) {
            return (XnioIoThread)thread;
        }
        return null;
    }

    public static XnioIoThread requireCurrentThread() throws IllegalStateException {
        XnioIoThread thread = XnioIoThread.currentThread();
        if (thread == null) {
            throw Messages.msg.xnioThreadRequired();
        }
        return thread;
    }

    public int getNumber() {
        return this.number;
    }

    public XnioWorker getWorker() {
        return this.worker;
    }

    @Override
    public IoFuture<StreamConnection> acceptStreamConnection(SocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw Messages.msg.nullParameter("destination");
        }
        if (destination instanceof InetSocketAddress) {
            return this.acceptTcpStreamConnection((InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptLocalStreamConnection((LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    protected IoFuture<StreamConnection> acceptLocalStreamConnection(LocalSocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("acceptLocalStreamConnection");
    }

    protected IoFuture<StreamConnection> acceptTcpStreamConnection(InetSocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("acceptTcpStreamConnection");
    }

    @Override
    public IoFuture<MessageConnection> openMessageConnection(SocketAddress destination, ChannelListener<? super MessageConnection> openListener, OptionMap optionMap) {
        if (destination == null) {
            throw Messages.msg.nullParameter("destination");
        }
        if (destination instanceof LocalSocketAddress) {
            return this.openLocalMessageConnection(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    @Override
    public IoFuture<MessageConnection> acceptMessageConnection(SocketAddress destination, ChannelListener<? super MessageConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination == null) {
            throw Messages.msg.nullParameter("destination");
        }
        if (destination instanceof LocalSocketAddress) {
            return this.acceptLocalMessageConnection((LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    protected IoFuture<MessageConnection> acceptLocalMessageConnection(LocalSocketAddress destination, ChannelListener<? super MessageConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("acceptLocalMessageConnection");
    }

    @Override
    public IoFuture<StreamConnection> openStreamConnection(SocketAddress destination, ChannelListener<? super StreamConnection> openListener, OptionMap optionMap) {
        Assert.checkNotNullParam((String)"destination", (Object)destination);
        if (destination instanceof InetSocketAddress) {
            return this.internalOpenTcpStreamConnection((InetSocketAddress)destination, openListener, null, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.openLocalStreamConnection(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, null, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    @Override
    public IoFuture<StreamConnection> openStreamConnection(SocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        Assert.checkNotNullParam((String)"destination", (Object)destination);
        if (destination instanceof InetSocketAddress) {
            return this.internalOpenTcpStreamConnection((InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.openLocalStreamConnection(Xnio.ANY_LOCAL_ADDRESS, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    private IoFuture<StreamConnection> internalOpenTcpStreamConnection(InetSocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        if (destination.isUnresolved()) {
            try {
                destination = new InetSocketAddress(InetAddress.getByName(destination.getHostString()), destination.getPort());
            }
            catch (UnknownHostException e) {
                return new FailedIoFuture<StreamConnection>(e);
            }
        }
        InetSocketAddress bindAddress = (InetSocketAddress)this.getWorker().getBindAddressTable().get(destination.getAddress());
        return this.openTcpStreamConnection(bindAddress, destination, openListener, bindListener, optionMap);
    }

    @Override
    public IoFuture<StreamConnection> openStreamConnection(SocketAddress bindAddress, SocketAddress destination, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        Assert.checkNotNullParam((String)"bindAddress", (Object)bindAddress);
        Assert.checkNotNullParam((String)"destination", (Object)destination);
        if (bindAddress.getClass() != destination.getClass()) {
            throw Messages.msg.mismatchSockType(bindAddress.getClass(), destination.getClass());
        }
        if (destination instanceof InetSocketAddress) {
            SocketAddress configuredAddress = ANY_INET_ADDRESS.equals(bindAddress) ? (InetSocketAddress)this.getWorker().getBindAddressTable().get(((InetSocketAddress)destination).getAddress()) : null;
            bindAddress = configuredAddress != null ? configuredAddress : bindAddress;
            return this.openTcpStreamConnection((InetSocketAddress)bindAddress, (InetSocketAddress)destination, openListener, bindListener, optionMap);
        }
        if (destination instanceof LocalSocketAddress) {
            return this.openLocalStreamConnection((LocalSocketAddress)bindAddress, (LocalSocketAddress)destination, openListener, bindListener, optionMap);
        }
        throw Messages.msg.badSockType(destination.getClass());
    }

    protected IoFuture<StreamConnection> openTcpStreamConnection(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("openTcpStreamConnection");
    }

    protected IoFuture<StreamConnection> openLocalStreamConnection(LocalSocketAddress bindAddress, LocalSocketAddress destinationAddress, ChannelListener<? super StreamConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("openLocalStreamConnection");
    }

    protected IoFuture<MessageConnection> openLocalMessageConnection(LocalSocketAddress bindAddress, LocalSocketAddress destinationAddress, ChannelListener<? super MessageConnection> openListener, OptionMap optionMap) {
        throw Messages.msg.unsupported("openLocalMessageConnection");
    }

    @Override
    public ChannelPipe<StreamChannel, StreamChannel> createFullDuplexPipe() throws IOException {
        ChannelPipe<StreamConnection, StreamConnection> connection = this.createFullDuplexPipeConnection();
        AssembledStreamChannel left = new AssembledStreamChannel(connection.getLeftSide(), connection.getLeftSide().getSourceChannel(), connection.getLeftSide().getSinkChannel());
        AssembledStreamChannel right = new AssembledStreamChannel(connection.getRightSide(), connection.getRightSide().getSourceChannel(), connection.getRightSide().getSinkChannel());
        return new ChannelPipe<StreamChannel, StreamChannel>(left, right);
    }

    @Override
    public ChannelPipe<StreamConnection, StreamConnection> createFullDuplexPipeConnection() throws IOException {
        return this.createFullDuplexPipeConnection(this);
    }

    @Override
    public ChannelPipe<StreamSourceChannel, StreamSinkChannel> createHalfDuplexPipe() throws IOException {
        return this.createHalfDuplexPipe(this);
    }

    @Override
    public ChannelPipe<StreamConnection, StreamConnection> createFullDuplexPipeConnection(XnioIoFactory peer) throws IOException {
        throw Messages.msg.unsupported("createFullDuplexPipeConnection");
    }

    @Override
    public ChannelPipe<StreamSourceChannel, StreamSinkChannel> createHalfDuplexPipe(XnioIoFactory peer) throws IOException {
        throw Messages.msg.unsupported("createHalfDuplexPipe");
    }
}

