/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.http.netty.server.util.Utils;

public class NettyServletContext
implements ServletContext {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyServletContext.class);
    private Map<String, Object> attributes;
    private Map<String, String> initParameters;
    private String servletContextName;
    private final String contextPath;

    public NettyServletContext(String contextPath) {
        this.contextPath = contextPath;
    }

    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    public Enumeration getAttributeNames() {
        return Utils.enumerationFromKeys(this.attributes);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public URL getResource(String path) throws MalformedURLException {
        return NettyServletContext.class.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return NettyServletContext.class.getResourceAsStream(path);
    }

    public String getServerInfo() {
        return "Netty Servlet";
    }

    public void addInitParameter(String name, String value) {
        if (this.initParameters == null) {
            this.initParameters = new HashMap<String, String>();
        }
        this.initParameters.put(name, value);
    }

    public String getInitParameter(String name) {
        if (this.initParameters == null) {
            return null;
        }
        return this.initParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Utils.enumerationFromKeys(this.initParameters);
    }

    public void log(String msg) {
        LOG.info(msg);
    }

    public void log(Exception exception, String msg) {
        LOG.log(Level.SEVERE, msg, exception);
    }

    public void log(String message, Throwable throwable) {
        LOG.log(Level.SEVERE, message, throwable);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, object);
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public Servlet getServlet(String name) throws ServletException {
        throw new IllegalStateException("Deprecated as of Java Servlet API 2.1, with no direct replacement!");
    }

    public Enumeration getServletNames() {
        throw new IllegalStateException("Method 'getServletNames' deprecated as of Java Servlet API 2.0, with no replacement.");
    }

    public Enumeration getServlets() {
        throw new IllegalStateException("Method 'getServlets' deprecated as of Java Servlet API 2.0, with no replacement.");
    }

    public ServletContext getContext(String uripath) {
        return this;
    }

    public String getMimeType(String file) {
        return Utils.getMimeType(file);
    }

    public Set getResourcePaths(String path) {
        throw new IllegalStateException("Method 'getResourcePaths' not yet implemented!");
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new IllegalStateException("Method 'getNamedDispatcher' not yet implemented!");
    }

    public String getRealPath(String path) {
        throw new IllegalStateException("Method 'getRealPath' not yet implemented!");
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new IllegalStateException("Method 'getRequestDispatcher' not yet implemented!");
    }

    public int getEffectiveMajorVersion() {
        throw new IllegalStateException("Method 'getEffectiveMajorVersion' not yet implemented!");
    }

    public int getEffectiveMinorVersion() {
        throw new IllegalStateException("Method 'getEffectiveMinorVersion' not yet implemented!");
    }

    public boolean setInitParameter(String name, String value) {
        throw new IllegalStateException("Method 'setInitParameter' not yet implemented!");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new IllegalStateException("Method 'addServlet' not yet implemented!");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new IllegalStateException("Method 'addServlet' not yet implemented!");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new IllegalStateException("Method 'addServlet' not yet implemented!");
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        throw new IllegalStateException("Method 'addJspFile' not yet implemented!");
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new IllegalStateException("Method 'createServlet' not yet implemented!");
    }

    public ServletRegistration getServletRegistration(String servletName) {
        throw new IllegalStateException("Method 'getServletRegistration' not yet implemented!");
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        throw new IllegalStateException("Method 'getServletRegistrations' not yet implemented!");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new IllegalStateException("Method 'addFilter' not yet implemented!");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new IllegalStateException("Method 'addFilter' not yet implemented!");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new IllegalStateException("Method 'addFilter' not yet implemented!");
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new IllegalStateException("Method 'createFilter' not yet implemented!");
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        throw new IllegalStateException("Method 'getFilterRegistration' not yet implemented!");
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        throw new IllegalStateException("Method 'getFilterRegistrations' not yet implemented!");
    }

    public SessionCookieConfig getSessionCookieConfig() {
        throw new IllegalStateException("Method 'getSessionCookieConfig' not yet implemented!");
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new IllegalStateException("Method 'setSessionTrackingModes' not yet implemented!");
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        throw new IllegalStateException("Method 'getDefaultSessionTrackingModes' not yet implemented!");
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        throw new IllegalStateException("Method 'getEffectiveSessionTrackingModes' not yet implemented!");
    }

    public void addListener(String className) {
        throw new IllegalStateException("Method 'addListener' not yet implemented!");
    }

    public <T extends EventListener> void addListener(T t) {
        throw new IllegalStateException("Method 'addListener' not yet implemented!");
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new IllegalStateException("Method 'addListener' not yet implemented!");
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new IllegalStateException("Method 'createListener' not yet implemented!");
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new IllegalStateException("Method 'getJspConfigDescriptor' not yet implemented!");
    }

    public ClassLoader getClassLoader() {
        throw new IllegalStateException("Method 'getClassLoader' not yet implemented!");
    }

    public void declareRoles(String ... roleNames) {
        throw new IllegalStateException("Method 'declareRoles' not yet implemented!");
    }

    public String getVirtualServerName() {
        throw new IllegalStateException("Method 'getVirtualServerName' not yet implemented!");
    }

    public int getSessionTimeout() {
        throw new IllegalStateException("Method 'getSessionTimeout' not yet implemented!");
    }

    public void setSessionTimeout(int sessionTimeout) {
        throw new IllegalStateException("Method 'setSessionTimeout' not yet implemented!");
    }

    public String getRequestCharacterEncoding() {
        throw new IllegalStateException("Method 'getRequestCharacterEncoding' not yet implemented!");
    }

    public void setRequestCharacterEncoding(String encoding) {
        throw new IllegalStateException("Method 'setRequestCharacterEncoding' not yet implemented!");
    }

    public String getResponseCharacterEncoding() {
        throw new IllegalStateException("Method 'getResponseCharacterEncoding' not yet implemented!");
    }

    public void setResponseCharacterEncoding(String encoding) {
        throw new IllegalStateException("Method 'setResponseCharacterEncoding' not yet implemented!");
    }
}

