/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.client.config;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.Delimiterator;
import org.wildfly.client.config.XMLLocation;
import org.wildfly.client.config._private.ConfigMessages;
import org.wildfly.common.expression.Expression;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.common.net.Inet;

public interface ConfigurationXMLStreamReader
extends XMLStreamReader,
AutoCloseable {
    public static final char[] EMPTY_CHARS = new char[0];

    public URI getUri();

    public XMLInputFactory getXmlInputFactory();

    public XMLLocation getIncludedFrom();

    @Override
    public boolean hasNext() throws ConfigXMLParseException;

    @Override
    public int next() throws ConfigXMLParseException;

    default public boolean hasNamespace() {
        String namespaceURI = this.getNamespaceURI();
        return namespaceURI != null && !namespaceURI.isEmpty();
    }

    default public boolean namespaceURIEquals(String uri) {
        return uri == null || uri.isEmpty() ? !this.hasNamespace() : uri.equals(this.getNamespaceURI());
    }

    default public boolean hasAttributeNamespace(int idx) {
        String attributeNamespace = this.getAttributeNamespace(idx);
        return attributeNamespace != null && !attributeNamespace.isEmpty();
    }

    default public boolean attributeNamespaceEquals(int idx, String uri) {
        return uri == null || uri.isEmpty() ? !this.hasAttributeNamespace(idx) : uri.equals(this.getAttributeNamespace(idx));
    }

    @Override
    default public int nextTag() throws ConfigXMLParseException {
        int eventType;
        block5: while (true) {
            eventType = this.next();
            switch (eventType) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 1: 
                case 2: {
                    return eventType;
                }
                case 4: 
                case 12: {
                    if (!this.isWhiteSpace()) break block5;
                    continue block5;
                }
            }
            break;
        }
        throw ConfigMessages.msg.expectedStartOrEndElement(ConfigurationXMLStreamReader.eventToString(eventType), this.getLocation());
    }

    @Override
    default public String getElementText() throws ConfigXMLParseException {
        int eventType = this.getEventType();
        if (eventType != 1) {
            throw ConfigMessages.msg.expectedStartElement(ConfigurationXMLStreamReader.eventToString(eventType), this.getLocation());
        }
        StringBuilder sb = new StringBuilder();
        block7: while (true) {
            eventType = this.next();
            switch (eventType) {
                case 2: {
                    return sb.toString();
                }
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    sb.append(this.getText());
                    continue block7;
                }
                case 3: 
                case 5: {
                    continue block7;
                }
                case 8: {
                    throw ConfigMessages.msg.unexpectedDocumentEnd(this.getLocation());
                }
                case 1: {
                    throw ConfigMessages.msg.textCannotContainElements(this.getLocation());
                }
            }
            break;
        }
        throw ConfigMessages.msg.unexpectedContent(ConfigurationXMLStreamReader.eventToString(eventType), this.getLocation());
    }

    default public Expression getElementExpression(Expression.Flag ... flags) throws ConfigXMLParseException {
        try {
            return Expression.compile((String)this.getElementText(), (Expression.Flag[])flags);
        }
        catch (IllegalArgumentException ex) {
            throw ConfigMessages.msg.expressionTextParseException(ex, this.getLocation());
        }
    }

    @Override
    default public void require(int type, String namespaceURI, String localName) throws ConfigXMLParseException {
        if (this.getEventType() != type) {
            throw ConfigMessages.msg.expectedEventType(ConfigurationXMLStreamReader.eventToString(type), ConfigurationXMLStreamReader.eventToString(this.getEventType()), this.getLocation());
        }
        if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
            throw ConfigMessages.msg.expectedNamespace(namespaceURI, this.getNamespaceURI(), this.getLocation());
        }
        if (localName != null && !localName.equals(this.getLocalName())) {
            throw ConfigMessages.msg.expectedLocalName(localName, this.getLocalName(), this.getLocation());
        }
    }

    @Override
    default public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    @Override
    default public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    @Override
    default public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    @Override
    default public boolean isWhiteSpace() {
        return this.getEventType() == 6 || this.getEventType() == 4 && this.getText().trim().isEmpty();
    }

    public static String eventToString(int type) {
        switch (type) {
            case 7: {
                return "document start";
            }
            case 8: {
                return "document end";
            }
            case 1: {
                return "start element";
            }
            case 2: {
                return "end element";
            }
            case 12: {
                return "cdata";
            }
            case 4: {
                return "characters";
            }
            case 10: {
                return "attribute";
            }
            case 11: {
                return "dtd";
            }
            case 15: {
                return "entity declaration";
            }
            case 9: {
                return "entity reference";
            }
            case 13: {
                return "namespace";
            }
            case 14: {
                return "notation declaration";
            }
            case 3: {
                return "processing instruction";
            }
            case 6: {
                return "white space";
            }
        }
        return "unknown";
    }

    @Override
    default public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    @Override
    default public boolean hasText() {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    default public boolean isStandalone() {
        return false;
    }

    @Override
    default public boolean standaloneSet() {
        return false;
    }

    @Override
    default public boolean hasName() {
        int eventType = this.getEventType();
        return eventType == 1 || eventType == 2;
    }

    @Override
    public XMLLocation getLocation();

    @Override
    public int getTextCharacters(int var1, char[] var2, int var3, int var4) throws ConfigXMLParseException;

    @Override
    public void close() throws ConfigXMLParseException;

    default public void skipContent() throws ConfigXMLParseException {
        while (this.hasNext()) {
            switch (this.next()) {
                case 1: {
                    this.skipContent();
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
    }

    default public ConfigXMLParseException unexpectedElement() {
        String namespaceURI = this.getNamespaceURI();
        String localName = this.getLocalName();
        if (namespaceURI == null) {
            return ConfigMessages.msg.unexpectedElement(localName, this.getLocation());
        }
        return ConfigMessages.msg.unexpectedElement(localName, namespaceURI, this.getLocation());
    }

    default public ConfigXMLParseException unexpectedAttribute(int i) {
        return ConfigMessages.msg.unexpectedAttribute(this.getAttributeName(i), this.getLocation());
    }

    default public ConfigXMLParseException unexpectedDocumentEnd() {
        return ConfigMessages.msg.unexpectedDocumentEnd(this.getLocation());
    }

    default public ConfigXMLParseException unexpectedContent() {
        return ConfigMessages.msg.unexpectedContent(ConfigurationXMLStreamReader.eventToString(this.getEventType()), this.getLocation());
    }

    default public ConfigXMLParseException missingRequiredElement(String namespaceUri, String localName) {
        return ConfigMessages.msg.missingRequiredElement(namespaceUri, localName, this.getLocation());
    }

    default public ConfigXMLParseException missingRequiredAttribute(String namespaceUri, String localName) {
        return ConfigMessages.msg.missingRequiredAttribute(namespaceUri, localName, this.getLocation());
    }

    default public ConfigXMLParseException numericAttributeValueOutOfRange(int index, long minValue, long maxValue) {
        return ConfigMessages.msg.numericAttributeValueOutOfRange(this.getAttributeName(index), this.getAttributeValue(index), minValue, maxValue, this.getLocation());
    }

    @Override
    public String getAttributeValue(int var1);

    default public String getAttributeValueResolved(int index) throws ConfigXMLParseException {
        Expression expression = this.getExpressionAttributeValue(index, Expression.Flag.ESCAPES);
        return expression.evaluateWithPropertiesAndEnvironment(false);
    }

    default public int getIntAttributeValue(int index) throws ConfigXMLParseException {
        try {
            return Integer.parseInt(this.getAttributeValue(index));
        }
        catch (NumberFormatException e) {
            throw ConfigMessages.msg.intParseException(e, this.getAttributeName(index), this.getLocation());
        }
    }

    default public int getIntAttributeValueResolved(int index) throws ConfigXMLParseException {
        try {
            return Integer.parseInt(this.getAttributeValueResolved(index));
        }
        catch (NumberFormatException e) {
            throw ConfigMessages.msg.intParseException(e, this.getAttributeName(index), this.getLocation());
        }
    }

    default public int getIntAttributeValue(int index, int minValue, int maxValue) throws ConfigXMLParseException {
        int value = this.getIntAttributeValue(index);
        if (value < minValue || value > maxValue) {
            throw this.numericAttributeValueOutOfRange(index, minValue, maxValue);
        }
        return value;
    }

    default public int getIntAttributeValueResolved(int index, int minValue, int maxValue) throws ConfigXMLParseException {
        int value = this.getIntAttributeValueResolved(index);
        if (value < minValue || value > maxValue) {
            throw this.numericAttributeValueOutOfRange(index, minValue, maxValue);
        }
        return value;
    }

    default public int[] getIntListAttributeValue(int index) throws ConfigXMLParseException {
        try {
            return new Delimiterator(this.getAttributeValue(index), ' ').toIntArray();
        }
        catch (NumberFormatException e) {
            throw ConfigMessages.msg.intParseException(e, this.getAttributeName(index), this.getLocation());
        }
    }

    default public int[] getIntListAttributeValueResolved(int index) throws ConfigXMLParseException {
        try {
            return new Delimiterator(this.getAttributeValueResolved(index), ' ').toIntArray();
        }
        catch (NumberFormatException e) {
            throw ConfigMessages.msg.intParseException(e, this.getAttributeName(index), this.getLocation());
        }
    }

    default public Iterator<String> getListAttributeValueAsIterator(int index) throws ConfigXMLParseException {
        return new Delimiterator(this.getAttributeValue(index), ' ');
    }

    default public Iterator<String> getListAttributeValueAsIteratorResolved(int index) throws ConfigXMLParseException {
        return new Delimiterator(this.getAttributeValueResolved(index), ' ');
    }

    default public List<String> getListAttributeValue(int index) throws ConfigXMLParseException {
        return Arrays.asList(this.getListAttributeValueAsArray(index));
    }

    default public List<String> getListAttributeValueResolved(int index) throws ConfigXMLParseException {
        return Arrays.asList(this.getListAttributeValueAsArrayResolved(index));
    }

    default public String[] getListAttributeValueAsArray(int index) throws ConfigXMLParseException {
        return new Delimiterator(this.getAttributeValue(index), ' ').toStringArray();
    }

    default public String[] getListAttributeValueAsArrayResolved(int index) throws ConfigXMLParseException {
        return new Delimiterator(this.getAttributeValueResolved(index), ' ').toStringArray();
    }

    default public long getLongAttributeValue(int index) throws ConfigXMLParseException {
        try {
            return Long.parseLong(this.getAttributeValue(index));
        }
        catch (NumberFormatException e) {
            throw ConfigMessages.msg.intParseException(e, this.getAttributeName(index), this.getLocation());
        }
    }

    default public long getLongAttributeValueResolved(int index) throws ConfigXMLParseException {
        try {
            return Long.parseLong(this.getAttributeValueResolved(index));
        }
        catch (NumberFormatException e) {
            throw ConfigMessages.msg.intParseException(e, this.getAttributeName(index), this.getLocation());
        }
    }

    default public long getLongAttributeValue(int index, long minValue, long maxValue) throws ConfigXMLParseException {
        long value = this.getLongAttributeValue(index);
        if (value < minValue || value > maxValue) {
            throw this.numericAttributeValueOutOfRange(index, minValue, maxValue);
        }
        return value;
    }

    default public long getLongAttributeValueResolved(int index, long minValue, long maxValue) throws ConfigXMLParseException {
        long value = this.getLongAttributeValueResolved(index);
        if (value < minValue || value > maxValue) {
            throw this.numericAttributeValueOutOfRange(index, minValue, maxValue);
        }
        return value;
    }

    default public long[] getLongListAttributeValue(int index) throws ConfigXMLParseException {
        try {
            return new Delimiterator(this.getAttributeValue(index), ' ').toLongArray();
        }
        catch (NumberFormatException e) {
            throw ConfigMessages.msg.intParseException(e, this.getAttributeName(index), this.getLocation());
        }
    }

    default public long[] getLongListAttributeValueResolved(int index) throws ConfigXMLParseException {
        try {
            return new Delimiterator(this.getAttributeValueResolved(index), ' ').toLongArray();
        }
        catch (NumberFormatException e) {
            throw ConfigMessages.msg.intParseException(e, this.getAttributeName(index), this.getLocation());
        }
    }

    default public boolean getBooleanAttributeValue(int index) {
        return Boolean.parseBoolean(this.getAttributeValue(index));
    }

    default public boolean getBooleanAttributeValueResolved(int index) throws ConfigXMLParseException {
        return Boolean.parseBoolean(this.getAttributeValueResolved(index));
    }

    default public URI getURIAttributeValue(int index) throws ConfigXMLParseException {
        try {
            return new URI(this.getAttributeValue(index));
        }
        catch (URISyntaxException e) {
            throw ConfigMessages.msg.uriParseException(e, this.getAttributeName(index), this.getLocation());
        }
    }

    default public URI getURIAttributeValueResolved(int index) throws ConfigXMLParseException {
        try {
            return new URI(this.getAttributeValueResolved(index));
        }
        catch (URISyntaxException e) {
            throw ConfigMessages.msg.uriParseException(e, this.getAttributeName(index), this.getLocation());
        }
    }

    default public Expression getExpressionAttributeValue(int index, Expression.Flag ... flags) throws ConfigXMLParseException {
        String attributeValue = this.getAttributeValue(index);
        if (attributeValue == null) {
            return null;
        }
        try {
            return Expression.compile((String)attributeValue, (Expression.Flag[])flags);
        }
        catch (IllegalArgumentException ex) {
            throw ConfigMessages.msg.expressionParseException(ex, this.getAttributeName(index), this.getLocation());
        }
    }

    default public InetAddress getInetAddressAttributeValue(int index) throws ConfigXMLParseException {
        String attributeValue = this.getAttributeValue(index);
        if (attributeValue == null) {
            return null;
        }
        InetAddress inetAddress = Inet.parseInetAddress((String)attributeValue);
        if (inetAddress == null) {
            throw ConfigMessages.msg.inetAddressParseException(this.getAttributeName(index), attributeValue, this.getLocation());
        }
        return inetAddress;
    }

    default public InetAddress getInetAddressAttributeValueResolved(int index) throws ConfigXMLParseException {
        String attributeValue = this.getAttributeValueResolved(index);
        if (attributeValue == null) {
            return null;
        }
        InetAddress inetAddress = Inet.parseInetAddress((String)attributeValue);
        if (inetAddress == null) {
            throw ConfigMessages.msg.inetAddressParseException(this.getAttributeName(index), attributeValue, this.getLocation());
        }
        return inetAddress;
    }

    default public CidrAddress getCidrAddressAttributeValue(int index) throws ConfigXMLParseException {
        String attributeValue = this.getAttributeValue(index);
        if (attributeValue == null) {
            return null;
        }
        CidrAddress cidrAddress = Inet.parseCidrAddress((String)attributeValue);
        if (cidrAddress == null) {
            throw ConfigMessages.msg.cidrAddressParseException(this.getAttributeName(index), attributeValue, this.getLocation());
        }
        return cidrAddress;
    }

    default public CidrAddress getCidrAddressAttributeValueResolved(int index) throws ConfigXMLParseException {
        String attributeValue = this.getAttributeValueResolved(index);
        if (attributeValue == null) {
            return null;
        }
        CidrAddress cidrAddress = Inet.parseCidrAddress((String)attributeValue);
        if (cidrAddress == null) {
            throw ConfigMessages.msg.cidrAddressParseException(this.getAttributeName(index), attributeValue, this.getLocation());
        }
        return cidrAddress;
    }
}

