/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ScheduledDeliveryHandler;
import org.apache.activemq.artemis.core.server.impl.QueueMessageMetrics;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledDeliveryHandlerImpl
implements ScheduledDeliveryHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ScheduledExecutorService scheduledExecutor;
    private final Map<Long, Runnable> runnables = new ConcurrentHashMap<Long, Runnable>();
    private final TreeSet<RefScheduled> scheduledReferences = new TreeSet<RefScheduled>(new MessageReferenceComparator());
    private final QueueMessageMetrics metrics;

    public ScheduledDeliveryHandlerImpl(ScheduledExecutorService scheduledExecutor, Queue queue) {
        this.scheduledExecutor = scheduledExecutor;
        this.metrics = new QueueMessageMetrics(queue, "scheduled");
    }

    @Override
    public boolean checkAndSchedule(MessageReference ref, boolean tail) {
        long deliveryTime = ref.getScheduledDeliveryTime();
        if (deliveryTime > 0L && this.scheduledExecutor != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Scheduling delivery for {} to occur at {}", (Object)ref, (Object)deliveryTime);
            }
            this.addInPlace(deliveryTime, ref, tail);
            this.scheduleDelivery(deliveryTime);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInPlace(long deliveryTime, MessageReference ref, boolean tail) {
        TreeSet<RefScheduled> treeSet = this.scheduledReferences;
        synchronized (treeSet) {
            this.scheduledReferences.add(new RefScheduled(ref, tail));
        }
        this.metrics.incrementMetrics(ref);
    }

    @Override
    public int getScheduledCount() {
        return this.metrics.getMessageCount();
    }

    @Override
    public int getDurableScheduledCount() {
        return this.metrics.getDurableMessageCount();
    }

    @Override
    public long getScheduledSize() {
        return this.metrics.getPersistentSize();
    }

    @Override
    public long getDurableScheduledSize() {
        return this.metrics.getDurablePersistentSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getScheduledReferences() {
        LinkedList<MessageReference> refs = new LinkedList<MessageReference>();
        TreeSet<RefScheduled> treeSet = this.scheduledReferences;
        synchronized (treeSet) {
            for (RefScheduled ref : this.scheduledReferences) {
                refs.add(ref.getRef());
            }
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> cancel(Predicate<MessageReference> predicate) throws ActiveMQException {
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        TreeSet<RefScheduled> treeSet = this.scheduledReferences;
        synchronized (treeSet) {
            Iterator<RefScheduled> iter = this.scheduledReferences.iterator();
            while (iter.hasNext()) {
                MessageReference ref = iter.next().getRef();
                if (!predicate.test(ref)) continue;
                iter.remove();
                refs.add(ref);
                this.metrics.decrementMetrics(ref);
            }
        }
        return refs;
    }

    @Override
    public MessageReference removeReferenceWithID(long id) throws Exception {
        return this.removeReferenceWithID(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReference removeReferenceWithID(long id, Transaction tx) throws Exception {
        TreeSet<RefScheduled> treeSet = this.scheduledReferences;
        synchronized (treeSet) {
            Iterator<RefScheduled> iter = this.scheduledReferences.iterator();
            while (iter.hasNext()) {
                MessageReference ref = iter.next().getRef();
                if (ref.getMessage().getMessageID() != id) continue;
                ref.acknowledge(tx);
                iter.remove();
                this.metrics.decrementMetrics(ref);
                return ref;
            }
        }
        return null;
    }

    private void scheduleDelivery(long deliveryTime) {
        long now = System.currentTimeMillis();
        long delay = deliveryTime - now;
        if (delay < 0L) {
            if (logger.isTraceEnabled()) {
                logger.trace("calling another scheduler now as deliverTime {} < now={}", (Object)deliveryTime, (Object)now);
            }
            ScheduledDeliveryRunnable runnable = new ScheduledDeliveryRunnable(deliveryTime);
            this.scheduledExecutor.schedule(runnable, 0L, TimeUnit.MILLISECONDS);
        } else if (!this.runnables.containsKey(deliveryTime)) {
            ScheduledDeliveryRunnable runnable = new ScheduledDeliveryRunnable(deliveryTime);
            if (logger.isTraceEnabled()) {
                logger.trace("Setting up scheduler for {} with a delay of {} as now={}", new Object[]{deliveryTime, delay, now});
            }
            this.runnables.put(deliveryTime, runnable);
            this.scheduledExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
        } else if (logger.isTraceEnabled()) {
            logger.trace("Couldn't make another scheduler as {} is already set, now is {}", (Object)deliveryTime, (Object)now);
        }
    }

    static class MessageReferenceComparator
    implements Comparator<RefScheduled> {
        MessageReferenceComparator() {
        }

        @Override
        public int compare(RefScheduled ref1, RefScheduled ref2) {
            long diff = ref1.getRef().getScheduledDeliveryTime() - ref2.getRef().getScheduledDeliveryTime();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            if (ref1 == ref2) {
                return 0;
            }
            if (ref1.isTail() && !ref2.isTail()) {
                return 1;
            }
            if (!ref1.isTail() && ref2.isTail()) {
                return -1;
            }
            if (!ref1.isTail() && !ref2.isTail()) {
                return -1;
            }
            return 1;
        }
    }

    class RefScheduled {
        private final MessageReference ref;
        private final boolean tail;

        RefScheduled(MessageReference ref, boolean tail) {
            this.ref = ref;
            this.tail = tail;
        }

        public MessageReference getRef() {
            return this.ref;
        }

        public boolean isTail() {
            return this.tail;
        }
    }

    private class ScheduledDeliveryRunnable
    implements Runnable {
        long deliveryTime;

        private ScheduledDeliveryRunnable(long deliveryTime) {
            this.deliveryTime = deliveryTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap refs = new HashMap();
            ScheduledDeliveryHandlerImpl.this.runnables.remove(this.deliveryTime);
            long now = System.currentTimeMillis();
            if (now < this.deliveryTime) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Scheduler is working around OS imprecisions on timing and re-scheduling an executor. now={} and deliveryTime={}", (Object)now, (Object)this.deliveryTime);
                }
                ScheduledDeliveryHandlerImpl.this.scheduleDelivery(this.deliveryTime);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("It is {} now and we are running deliveryTime = {}", (Object)System.currentTimeMillis(), (Object)this.deliveryTime);
            }
            TreeSet<RefScheduled> treeSet = ScheduledDeliveryHandlerImpl.this.scheduledReferences;
            synchronized (treeSet) {
                MessageReference reference;
                Iterator<RefScheduled> iterator = ScheduledDeliveryHandlerImpl.this.scheduledReferences.iterator();
                while (iterator.hasNext() && (reference = iterator.next().getRef()).getScheduledDeliveryTime() <= now) {
                    iterator.remove();
                    ScheduledDeliveryHandlerImpl.this.metrics.decrementMetrics(reference);
                    reference.setScheduledDeliveryTime(0L);
                    LinkedList<MessageReference> references = (LinkedList<MessageReference>)refs.get(reference.getQueue());
                    if (references == null) {
                        references = new LinkedList<MessageReference>();
                        refs.put(reference.getQueue(), references);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("sending message {} to delivery, deliveryTime = {}", (Object)reference, (Object)this.deliveryTime);
                    }
                    references.addFirst(reference);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Finished loop on deliveryTime = {}", (Object)this.deliveryTime);
                }
            }
            for (Map.Entry entry : refs.entrySet()) {
                Queue queue = (Queue)entry.getKey();
                LinkedList list = (LinkedList)entry.getValue();
                if (logger.isTraceEnabled()) {
                    logger.trace("Delivering {} elements on list to queue {}", (Object)list.size(), (Object)queue);
                }
                queue.addHead(list, true);
            }
            refs.clear();
        }
    }
}

