/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.transfer.dialect.fragment.language;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.ws.transfer.Representation;
import org.apache.cxf.ws.transfer.dialect.fragment.ExpressionType;
import org.apache.cxf.ws.transfer.dialect.fragment.faults.InvalidExpression;
import org.apache.cxf.ws.transfer.dialect.fragment.language.FragmentDialectLanguage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FragmentDialectLanguageQName
implements FragmentDialectLanguage {
    private static Pattern qNamePattern;

    public FragmentDialectLanguageQName() {
        if (qNamePattern == null) {
            String qName = FragmentDialectLanguageQName.getQNamePatternString();
            qNamePattern = Pattern.compile("^" + qName);
        }
    }

    public static String getQNamePatternString() {
        String ncNameStartChar = "[A-Z]|_|[a-z]|[\\x{c0}-\\x{d6}]|[\\x{d8}-\\x{f6}]|[\\x{f8}-\\x{2ff}]|[\\x{370}-\\x{37d}]|[\\x{37f}-\\x{1fff}]|[\\x{200c}-\\x{200d}]|[\\x{2070}-\\x{218f}]|[\\x{2c00}-\\x{2fef}]|[\\x{3001}-\\x{d7ff}]|[\\x{f900}-\\x{fdcf}]|[\\x{fdf0}-\\x{fffd}]|[\\x{10000}-\\x{effff}]";
        String ncNameChar = ncNameStartChar + "|-|\\.|[0-9]|\\x{b7}|[\\x{0300}-\\x{036f}]|[\\x{203f}-\\x{2040}]";
        String ncName = String.format("(%s)(%s)*", ncNameStartChar, ncNameChar);
        return String.format("((%s):)?(%s)", ncName, ncName);
    }

    @Override
    public Object getResourceFragment(final Representation representation, ExpressionType expression) {
        String expressionStr = this.getXPathFromQNameExpression(expression);
        XPathUtils xu = new XPathUtils(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix != null && !prefix.isEmpty()) {
                    Element resource = (Element)representation.getAny();
                    return resource.getAttribute("xmlns:" + prefix);
                }
                return null;
            }

            @Override
            public String getPrefix(String s) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<String> getPrefixes(String s) {
                throw new UnsupportedOperationException();
            }
        });
        Node resource = (Node)representation.getAny();
        if (resource == null) {
            return new NodeList(){

                @Override
                public Node item(int i) {
                    return null;
                }

                @Override
                public int getLength() {
                    return 0;
                }
            };
        }
        return xu.getValueList(expressionStr, resource);
    }

    private String getXPathFromQNameExpression(ExpressionType expression) {
        if (expression.getContent().size() == 1) {
            String expressionValue = (String)expression.getContent().get(0);
            Matcher m = qNamePattern.matcher(expressionValue);
            if (m.matches()) {
                return "/node()/" + expressionValue;
            }
            throw new InvalidExpression();
        }
        throw new InvalidExpression();
    }
}

