/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.GossipType;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class GossipData
implements SizeStreamable {
    GossipType type;
    String group;
    Address addr;
    Address sender;
    PhysicalAddress physical_addr;
    String logical_name;
    List<PingData> ping_data;
    byte[] buffer;
    int offset;
    int length;

    public GossipData() {
    }

    public GossipData(GossipType type) {
        this.type = type;
    }

    public GossipData(GossipType type, String group, Address addr) {
        this(type);
        this.group = group;
        this.addr = addr;
    }

    public GossipData(GossipType type, String group, Address addr, List<PingData> ping_data) {
        this(type, group, addr);
        this.ping_data = ping_data;
    }

    public GossipData(GossipType type, String group, Address addr, List<PingData> ping_data, PhysicalAddress physical_addr) {
        this(type, group, addr, ping_data);
        this.physical_addr = physical_addr;
    }

    public GossipData(GossipType type, String group, Address addr, String logical_name, PhysicalAddress physical_addr) {
        this(type, group, addr);
        this.logical_name = logical_name;
        this.physical_addr = physical_addr;
    }

    public GossipData(GossipType type, String group, Address addr, byte[] buffer) {
        this(type, group, addr, buffer, 0, buffer.length);
    }

    public GossipData(GossipType type, String group, Address addr, byte[] buffer, int offset, int length) {
        this(type, group, addr);
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public GossipType getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public Address getAddress() {
        return this.addr;
    }

    public Address getSender() {
        return this.sender;
    }

    public GossipData setSender(Address s) {
        this.sender = s;
        return this;
    }

    public String getLogicalName() {
        return this.logical_name;
    }

    public List<PingData> getPingData() {
        return this.ping_data;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public PhysicalAddress getPhysicalAddress() {
        return this.physical_addr;
    }

    public GossipData setPingData(List<PingData> mbrs) {
        this.ping_data = mbrs;
        return this;
    }

    public GossipData addPingData(PingData data) {
        if (this.ping_data == null) {
            this.ping_data = new ArrayList<PingData>();
        }
        if (data != null) {
            this.ping_data.add(data);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.type).append("(").append("group=").append(this.group).append(", addr=").append(this.addr);
        if (this.logical_name != null) {
            sb.append(", logical_name=" + this.logical_name);
        }
        if (this.ping_data != null && !this.ping_data.isEmpty()) {
            sb.append(", ping_data=").append(this.ping_data);
        }
        if (this.physical_addr != null) {
            sb.append(", physical_addr=").append(this.physical_addr);
        }
        if (this.buffer != null) {
            sb.append(", buffer: " + this.length + " bytes");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int serializedSize() {
        int retval = 1;
        if (this.group != null) {
            retval += this.group.length() + 2;
        }
        ++retval;
        retval += Util.size(this.addr);
        retval += Util.size(this.sender);
        if (this.type != GossipType.MESSAGE) {
            ++retval;
            if (this.logical_name != null) {
                retval += this.logical_name.length() + 2;
            }
            retval += 2;
            if (this.ping_data != null) {
                for (PingData data : this.ping_data) {
                    retval += data.serializedSize();
                }
            }
            retval += Util.size(this.physical_addr);
        }
        retval += 4;
        if (this.buffer != null) {
            retval += this.length;
        }
        return retval;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.type.ordinal());
        Bits.writeString(this.group, out);
        Util.writeAddress(this.addr, out);
        Util.writeAddress(this.sender, out);
        if (this.type != GossipType.MESSAGE) {
            Bits.writeString(this.logical_name, out);
            out.writeShort(this.ping_data != null ? this.ping_data.size() : 0);
            if (this.ping_data != null) {
                for (PingData data : this.ping_data) {
                    data.writeTo(out);
                }
            }
            Util.writeAddress(this.physical_addr, out);
        }
        out.writeInt(this.buffer != null ? this.length : 0);
        if (this.buffer != null) {
            out.write(this.buffer, this.offset, this.length);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.readFrom(in, true);
    }

    public void readFrom(DataInput in, boolean read_type) throws IOException, ClassNotFoundException {
        this.readFrom(in, read_type, true);
    }

    public void readFrom(DataInput in, boolean read_type, boolean read_payload) throws IOException, ClassNotFoundException {
        if (read_type) {
            this.type = GossipType.values()[in.readByte()];
        }
        this.group = Bits.readString(in);
        this.addr = Util.readAddress(in);
        this.sender = Util.readAddress(in);
        if (this.type != GossipType.MESSAGE) {
            this.logical_name = Bits.readString(in);
            int len = in.readShort();
            if (len > 0) {
                this.ping_data = new ArrayList<PingData>(len);
                for (int i = 0; i < len; ++i) {
                    PingData data = new PingData();
                    data.readFrom(in);
                    this.ping_data.add(data);
                }
            }
            this.physical_addr = (PhysicalAddress)Util.readAddress(in);
        }
        this.length = in.readInt();
        if (this.length > 0 && read_payload) {
            this.buffer = new byte[this.length];
            this.offset = 0;
            in.readFully(this.buffer, 0, this.length);
        }
    }
}

