/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Cookie;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.saml.sso.LogoutResponse;
import org.apache.cxf.rs.security.saml.sso.state.SPStateManager;
import org.apache.cxf.security.SecurityContext;

@Path(value="logout")
public class LogoutService {
    protected static final Logger LOG = LogUtils.getL7dLogger(LogoutService.class);
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(LogoutService.class);
    private SPStateManager stateProvider;
    private String mainApplicationAddress;

    @GET
    @Produces(value={"text/html"})
    public LogoutResponse logout(@CookieParam(value="org.apache.cxf.websso.context") Cookie context, @Context SecurityContext sc) {
        this.doLogout(context, sc);
        return new LogoutResponse(sc.getUserPrincipal().getName(), this.mainApplicationAddress);
    }

    @POST
    @Produces(value={"text/html"})
    public LogoutResponse postLogout(@CookieParam(value="org.apache.cxf.websso.context") Cookie context, @Context SecurityContext sc) {
        return this.logout(context, sc);
    }

    private void doLogout(Cookie context, SecurityContext sc) {
        if (context == null || sc.getUserPrincipal() == null || sc.getUserPrincipal().getName() == null) {
            this.reportError("MISSING_RESPONSE_STATE");
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        this.stateProvider.removeResponseState(context.getValue());
    }

    protected void reportError(String code) {
        Message errorMsg = new Message(code, BUNDLE, new Object[0]);
        LOG.warning(errorMsg.toString());
    }

    public void setStateProvider(SPStateManager stateProvider) {
        this.stateProvider = stateProvider;
    }

    public void setMainApplicationAddress(String mainApplicationAddress) {
        this.mainApplicationAddress = mainApplicationAddress;
    }
}

