/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.impl.InMemoryDuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.impl.NoOpDuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.impl.PersistentDuplicateIDCache;

public final class DuplicateIDCaches {
    private DuplicateIDCaches() {
    }

    public static DuplicateIDCache persistent(SimpleString address, int size, StorageManager storageManager) {
        if (size == 0) {
            return new NoOpDuplicateIDCache();
        }
        return new PersistentDuplicateIDCache(address, size, storageManager);
    }

    public static DuplicateIDCache inMemory(SimpleString address, int size) {
        if (size == 0) {
            return new NoOpDuplicateIDCache();
        }
        return new InMemoryDuplicateIDCache(address, size);
    }
}

