/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation.queue;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.utils.CompositeAddress;

public class FederatedQueueConsumerKey
implements FederatedConsumerKey {
    private final SimpleString address;
    private final SimpleString queueName;
    private final RoutingType routingType;
    private final SimpleString queueFilterString;
    private final SimpleString filterString;
    private final SimpleString fqqn;
    private final int priority;

    FederatedQueueConsumerKey(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString queueFilterString, SimpleString filterString, int priority) {
        this.address = address;
        this.routingType = routingType;
        this.queueName = queueName;
        this.fqqn = CompositeAddress.toFullyQualified((SimpleString)address, (SimpleString)queueName);
        this.filterString = filterString;
        this.queueFilterString = queueFilterString;
        this.priority = priority;
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }

    @Override
    public SimpleString getQueueFilterString() {
        return this.queueFilterString;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public SimpleString getFqqn() {
        return this.fqqn;
    }

    @Override
    public RoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public SimpleString getFilterString() {
        return this.filterString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FederatedQueueConsumerKey)) {
            return false;
        }
        FederatedQueueConsumerKey other = (FederatedQueueConsumerKey)obj;
        return this.priority == other.priority && Objects.equals(this.address, other.address) && Objects.equals(this.queueName, other.queueName) && this.routingType == other.routingType && Objects.equals(this.queueFilterString, other.queueFilterString) && Objects.equals(this.filterString, other.filterString) && Objects.equals(this.fqqn, other.fqqn);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.queueName, this.routingType, this.queueFilterString, this.filterString, this.fqqn, this.priority);
    }
}

