/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.servlet;

import org.apache.cxf.transport.http.netty.server.servlet.NettyHttpSession;
import org.apache.cxf.transport.http.netty.server.session.HttpSessionStore;

public final class HttpSessionThreadLocal {
    public static final ThreadLocal<NettyHttpSession> SESSION_THREAD_LOCAL = new ThreadLocal();
    private static HttpSessionStore sessionStore;

    private HttpSessionThreadLocal() {
    }

    public static HttpSessionStore getSessionStore() {
        return sessionStore;
    }

    public static void setSessionStore(HttpSessionStore store) {
        sessionStore = store;
    }

    public static void set(NettyHttpSession session) {
        SESSION_THREAD_LOCAL.set(session);
    }

    public static void unset() {
        SESSION_THREAD_LOCAL.remove();
    }

    public static NettyHttpSession get() {
        NettyHttpSession session = SESSION_THREAD_LOCAL.get();
        if (session != null) {
            session.touch();
        }
        return session;
    }

    public static NettyHttpSession getOrCreate() {
        if (HttpSessionThreadLocal.get() == null) {
            SESSION_THREAD_LOCAL.set(sessionStore.createSession());
        }
        return HttpSessionThreadLocal.get();
    }
}

