/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.generator;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.pkcs.PKCS12PfxPduBuilder;
import org.bouncycastle.pkcs.PKCS12SafeBag;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.bc.BcPKCS12MacCalculatorBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS12SafeBagBuilder;
import org.cryptacular.CryptoException;
import org.cryptacular.generator.P12Generator;
import org.cryptacular.spec.DigestSpec;

public abstract class AbstractP12Generator
implements P12Generator {
    @Override
    public PKCS12PfxPdu generate(char[] password, PrivateKey key, String alias, X509Certificate ... certificates) {
        if (certificates.length < 1) {
            throw new IllegalArgumentException("At least one certificate must be provided");
        }
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("Password cannot be null or empty");
        }
        PKCS12PfxPduBuilder pfxPduBuilder = new PKCS12PfxPduBuilder();
        PKCS12SafeBag[] certBags = new PKCS12SafeBag[certificates.length];
        try {
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            JcaPKCS12SafeBagBuilder keyBagBuilder = new JcaPKCS12SafeBagBuilder(key, this.keyOutputEncryptor(password));
            keyBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(alias));
            keyBagBuilder.addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(certificates[0].getPublicKey()));
            certBags[0] = new JcaPKCS12SafeBagBuilder(certificates[0]).addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(alias)).addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(certificates[0].getPublicKey())).build();
            for (int i = 1; i < certificates.length; ++i) {
                String label = "ca-cert-" + i;
                certBags[i] = new JcaPKCS12SafeBagBuilder(certificates[i]).addBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(label)).build();
            }
            pfxPduBuilder.addEncryptedData(this.dataOutputEncryptor(password), certBags);
            pfxPduBuilder.addData(keyBagBuilder.build());
            DigestSpec digestSpec = this.getDigestSpec();
            BcPKCS12MacCalculatorBuilder macCalculatorBuilder = new BcPKCS12MacCalculatorBuilder((ExtendedDigest)digestSpec.newInstance(), new AlgorithmIdentifier(this.getDigestAlgorithmId(), (ASN1Encodable)DERNull.INSTANCE)).setIterationCount(this.getIterations());
            return pfxPduBuilder.build((PKCS12MacCalculatorBuilder)macCalculatorBuilder, password);
        }
        catch (IOException | NoSuchAlgorithmException | PKCSException e) {
            throw new CryptoException("P12 generation failed", e);
        }
    }

    @Override
    public PKCS12PfxPdu generate(char[] password, PrivateKey key, X509Certificate ... certificates) {
        return this.generate(password, key, "end-entity-cert", certificates);
    }

    public abstract int getIterations();

    protected abstract ASN1ObjectIdentifier getDigestAlgorithmId();

    protected abstract DigestSpec getDigestSpec();

    protected abstract OutputEncryptor keyOutputEncryptor(char[] var1);

    protected abstract OutputEncryptor dataOutputEncryptor(char[] var1);
}

