/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.attachment.AttachmentBoundaryDeserializer;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.EntityPartImpl;
import org.apache.cxf.jaxrs.impl.ProvidersImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;
import org.apache.cxf.message.Message;

final class EntityPartUtils {
    private static final String MULTIPART_FORM_DATA_TYPE = "form-data";
    private static final String CONTENT_DISPOSITION_FILES_PARAM = "files";

    private EntityPartUtils() {
    }

    public static List<EntityPart> getEntityParts(MessageContext mc) {
        return EntityPartUtils.from(mc.getProviders(), AttachmentUtils.getMultipartBody(mc));
    }

    public static EntityPart getEntityPart(String value, Message message) {
        EntityPart entityPart;
        ProvidersImpl providers = new ProvidersImpl(message);
        ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
        try {
            AttachmentBoundaryDeserializer deserializer = new AttachmentBoundaryDeserializer(message);
            Attachment attachment = new Attachment(deserializer.read((InputStream)is), providers);
            entityPart = EntityPartUtils.createFromAttachment(providers, attachment);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
        }
        ((InputStream)is).close();
        return entityPart;
    }

    private static List<EntityPart> from(Providers providers, MultipartBody body) {
        List<Attachment> atts = body.getAllAttachments();
        ArrayList<EntityPart> parts = new ArrayList<EntityPart>(atts.size());
        for (Attachment a : atts) {
            EntityPart part = EntityPartUtils.createFromAttachment(providers, a);
            if (part == null) continue;
            parts.add(part);
        }
        return parts;
    }

    private static EntityPart createFromAttachment(Providers providers, Attachment a) {
        String name;
        ContentDisposition cd = a.getContentDisposition();
        if (cd != null && !MULTIPART_FORM_DATA_TYPE.equalsIgnoreCase(cd.getType())) {
            return null;
        }
        String fileName = cd != null ? cd.getFilename() : null;
        String cdName = cd == null ? null : cd.getParameter("name");
        String contentId = a.getContentId();
        String string = name = StringUtils.isEmpty((String)cdName) ? contentId : cdName.replace("\"", "").replace("'", "");
        if (StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)fileName)) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        if (CONTENT_DISPOSITION_FILES_PARAM.equals(name)) {
            return null;
        }
        try {
            InputStream is = a.getDataHandler().getInputStream();
            if (!StringUtils.isEmpty((String)fileName)) {
                return new EntityPartImpl(providers, name, fileName, is, InputStream.class, null, a.getHeaders(), a.getContentType());
            }
            return new EntityPartImpl(providers, name, null, is, InputStream.class, null, a.getHeaders(), a.getContentType());
        }
        catch (IOException ex) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
    }
}

