/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.agreement.impl.KeyAgreementParameterParser;
import org.opensaml.xmlsec.agreement.impl.KeySize;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.slf4j.Logger;

public class KeyAgreementParametersParser {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(KeyAgreementParametersParser.class);

    @Nonnull
    public KeyAgreementParameters parse(@Nonnull AgreementMethod agreementMethod) throws KeyAgreementException {
        Constraint.isNotNull((Object)agreementMethod, (String)"AgreementMethod was null");
        KeyAgreementParameters parameters = new KeyAgreementParameters();
        List<KeyAgreementParameterParser> parsers = this.getParsers();
        ArrayList xmlChildren = Lists.newArrayList((Iterable)agreementMethod.getUnknownXMLObjects());
        if (agreementMethod.getKANonce() != null) {
            xmlChildren.add(agreementMethod.getKANonce());
        }
        for (XMLObject xmlChild : xmlChildren) {
            assert (xmlChild != null);
            boolean handled = false;
            for (KeyAgreementParameterParser parser : parsers) {
                if (!parser.handles(xmlChild)) continue;
                this.log.debug("AgreementMethod child '{}' was indicated to be handled by: {}", (Object)xmlChild.getElementQName(), (Object)parser.getClass().getName());
                parameters.add((Object)parser.parse(xmlChild));
                handled = true;
            }
            if (handled) continue;
            throw new KeyAgreementException("AgreementMethod child is not a supported parameter type: " + String.valueOf(xmlChild.getElementQName()));
        }
        Integer keySize = KeyAgreementSupport.getExplicitKeySize((AgreementMethod)agreementMethod);
        if (keySize != null) {
            parameters.add((Object)new KeySize(keySize));
        }
        parameters.initializeAll();
        return parameters;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<KeyAgreementParameterParser> getParsers() {
        ServiceLoader<KeyAgreementParameterParser> loader = ServiceLoader.load(KeyAgreementParameterParser.class);
        return Lists.newArrayList(loader);
    }
}

