/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import java.util.List;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hive.quantiles.GetQuantilesFromStringsSketchUDF;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantilesFromStringsSketchUDFTest {
    static final Comparator<String> comparator = Comparator.naturalOrder();
    static final ArrayOfItemsSerDe<String> serDe = new ArrayOfStringsSerDe();

    @Test
    public void nullSketch() {
        List result = new GetQuantilesFromStringsSketchUDF().evaluate(null, new Double[]{0.0});
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyListOfFractions() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, comparator);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        sketch.update((Object)"c");
        List result = new GetQuantilesFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), new Double[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)0);
    }

    @Test
    public void fractionsNormalCase() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, comparator);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        sketch.update((Object)"c");
        sketch.update((Object)"d");
        List result = new GetQuantilesFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), new Double[]{0.0, 0.5, 1.0});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((String)((String)result.get(0)), (String)"a");
        Assert.assertEquals((String)((String)result.get(1)), (String)"b");
        Assert.assertEquals((String)((String)result.get(2)), (String)"d");
        result = new GetQuantilesFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), Boolean.valueOf(false), new Double[]{0.0, 0.5, 1.0});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((String)((String)result.get(0)), (String)"a");
        Assert.assertEquals((String)((String)result.get(1)), (String)"c");
        Assert.assertEquals((String)((String)result.get(2)), (String)"d");
    }

    @Test
    public void evenlySpacedZero() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, comparator);
        sketch.update((Object)"a");
        List result = new GetQuantilesFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), 0);
        Assert.assertNull((Object)result);
    }

    @Test
    public void evenlySpacedEmptySketch() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, comparator);
        List result = new GetQuantilesFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), 1);
        Assert.assertNull((Object)result);
    }

    @Test
    public void evenlySpacedNormalCase() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, comparator);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        sketch.update((Object)"c");
        sketch.update((Object)"d");
        List result = new GetQuantilesFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), 3);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((String)((String)result.get(0)), (String)"a");
        Assert.assertEquals((String)((String)result.get(1)), (String)"b");
        Assert.assertEquals((String)((String)result.get(2)), (String)"d");
        result = new GetQuantilesFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), Boolean.valueOf(false), 3);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((String)((String)result.get(0)), (String)"a");
        Assert.assertEquals((String)((String)result.get(1)), (String)"c");
        Assert.assertEquals((String)((String)result.get(2)), (String)"d");
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void fractionsWrongSketchType() {
        ItemsSketch sketch = ItemsSketch.getInstance(Long.class, Comparator.naturalOrder());
        sketch.update((Object)1L);
        sketch.update((Object)2L);
        sketch.update((Object)3L);
        new GetQuantilesFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe())), new Double[]{0.5});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void evenlySpacedWrongSketchType() {
        ItemsSketch sketch = ItemsSketch.getInstance(Long.class, Comparator.naturalOrder());
        sketch.update((Object)1L);
        sketch.update((Object)2L);
        sketch.update((Object)3L);
        new GetQuantilesFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe())), 1);
    }
}

