/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.theta.DataToSketchUDAF;
import org.apache.datasketches.hive.theta.UnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToSketchUDAFTest {
    static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    static final ObjectInspector doubleInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
    static final ObjectInspector stringInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING);
    static final ObjectInspector intConstantInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, null);
    static final ObjectInspector floatConstantInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.floatTypeInfo, null);
    static final ObjectInspector longConstantInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.longTypeInfo, null);
    static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "seed", "sketch"), Arrays.asList(intConstantInspector, longConstantInspector, binaryInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initTooFewArguments() throws SemanticException {
        DataToSketchUDAF udf = new DataToSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[0], false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initTooManyArguments() throws SemanticException {
        DataToSketchUDAF udf = new DataToSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{intInspector, intConstantInspector, floatConstantInspector, longConstantInspector, longConstantInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initInvalidCategoryArg1() throws SemanticException {
        DataToSketchUDAF udf = new DataToSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{structInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initInvalidCategoryArg2() throws SemanticException {
        DataToSketchUDAF udf = new DataToSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{intInspector, structInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initInvalidTypeArg2() throws SemanticException {
        DataToSketchUDAF udf = new DataToSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{intInspector, floatConstantInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initInvalidCategoryArg3() throws SemanticException {
        DataToSketchUDAF udf = new DataToSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{stringInspector, intConstantInspector, structInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initInvalidTypeArg3() throws SemanticException {
        DataToSketchUDAF udf = new DataToSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{stringInspector, intConstantInspector, intConstantInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initInvalidCategoryArg4() throws SemanticException {
        DataToSketchUDAF udf = new DataToSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{stringInspector, intConstantInspector, floatConstantInspector, structInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initInvalidTypeArg4() throws SemanticException {
        DataToSketchUDAF udf = new DataToSketchUDAF();
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(new ObjectInspector[]{stringInspector, intConstantInspector, floatConstantInspector, floatConstantInspector}, false, false, false);
        udf.getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test
    public void partial1ModeIntValuesDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(1)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(2)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Assert.assertEquals((long)((LongWritable)r.get(1)).get(), (long)9001L);
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertFalse((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void partial1ModeStringValuesExplicitParameters() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{stringInspector, intConstantInspector, floatConstantInspector, longConstantInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            long seed = 1L;
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new Text("a"), new IntWritable(16), new FloatWritable(0.99f), new LongWritable(1L)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new Text("b"), new IntWritable(16), new FloatWritable(0.99f), new LongWritable(1L)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)16);
            Assert.assertEquals((long)((LongWritable)r.get(1)).get(), (long)1L);
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))), (long)1L);
            Assert.assertTrue((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.05);
            Union union = SetOperation.builder().setSeed(1L).buildUnion();
            union.union(resultSketch);
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, new ObjectInspector[]{structInspector});
            DataToSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().build();
            sketch1.update(1L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new LongWritable(9001L), new BytesWritable(sketch1.compact().toByteArray())));
            UpdateSketch sketch2 = UpdateSketch.builder().build();
            sketch2.update(2L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new LongWritable(9001L), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Assert.assertEquals((long)((LongWritable)r.get(1)).get(), (long)9001L);
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{structInspector});
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            UpdateSketch sketch1 = UpdateSketch.builder().build();
            sketch1.update(1L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new LongWritable(9001L), new BytesWritable(sketch1.compact().toByteArray())));
            UpdateSketch sketch2 = UpdateSketch.builder().build();
            sketch2.update(2L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new LongWritable(9001L), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void completeModeIntValuesDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(1)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(2)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void completeModeDoubleValuesExplicitParameters() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector, intConstantInspector, floatConstantInspector, longConstantInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            long seed = 2L;
            UnionState state = (UnionState)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(1.0), new IntWritable(16), new FloatWritable(0.99f), new LongWritable(2L)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(2.0), new IntWritable(16), new FloatWritable(0.99f), new LongWritable(2L)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (long)2L);
            Assert.assertTrue((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.05);
        }
    }

    static void checkIntermediateResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.STRUCT);
        StructObjectInspector structResultInspector = (StructObjectInspector)resultInspector;
        List fields = structResultInspector.getAllStructFieldRefs();
        Assert.assertEquals((int)fields.size(), (int)3);
        ObjectInspector inspector1 = ((StructField)fields.get(0)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector1.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector1 = (PrimitiveObjectInspector)inspector1;
        Assert.assertEquals((Object)primitiveInspector1.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.INT);
        ObjectInspector inspector2 = ((StructField)fields.get(1)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector2.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector2 = (PrimitiveObjectInspector)inspector2;
        Assert.assertEquals((Object)primitiveInspector2.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.LONG);
        ObjectInspector inspector3 = ((StructField)fields.get(2)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector3.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector3 = (PrimitiveObjectInspector)inspector3;
        Assert.assertEquals((Object)primitiveInspector3.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }

    static void checkFinalResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)resultInspector).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }
}

