/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.theta.IntersectSketchUDF;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class IntersectSketchUDFTest {
    @Test
    public void evaluateNull() {
        IntersectSketchUDF testObject = new IntersectSketchUDF();
        try {
            BytesWritable bytesWritable = testObject.evaluate(null, null);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void evaluateEmpty() {
        IntersectSketchUDF testObject = new IntersectSketchUDF();
        try {
            BytesWritable bytesWritable = testObject.evaluate(new BytesWritable(), new BytesWritable());
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void evaluateValidSketch() {
        IntersectSketchUDF testObject = new IntersectSketchUDF();
        UpdateSketch sketch1 = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        UpdateSketch sketch2 = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 100; i < 128; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.compact().toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.compact().toByteArray());
        BytesWritable output = testObject.evaluate(input1, input2);
        Sketch result = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)output));
        AssertJUnit.assertEquals((Object)28.0, (Object)result.getEstimate());
    }

    @Test
    public void evaluateValidSketchExpicitSeed() {
        IntersectSketchUDF testObject = new IntersectSketchUDF();
        long seed = 1L;
        UpdateSketch sketch1 = Sketches.updateSketchBuilder().setSeed(1L).setNominalEntries(1024).build();
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        UpdateSketch sketch2 = Sketches.updateSketchBuilder().setSeed(1L).setNominalEntries(1024).build();
        for (int i = 100; i < 128; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.compact().toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.compact().toByteArray());
        BytesWritable output = testObject.evaluate(input1, input2, 1L);
        Sketch result = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)output), (long)1L);
        AssertJUnit.assertEquals((Object)28.0, (Object)result.getEstimate());
    }
}

