/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.tuple.DataToDoubleSummarySketchUDAFTest;
import org.apache.datasketches.hive.tuple.State;
import org.apache.datasketches.hive.tuple.UnionDoubleSummaryWithModeSketchUDAF;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionDoubleSummaryWithModeSketchUDAFTest {
    private static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    private static final ObjectInspector floatInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
    private static final ObjectInspector stringInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING);
    private static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    private static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "summaryMode", "sketch"), Arrays.asList(intInspector, stringInspector, binaryInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void tooFewArguments() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void tooManyArguments() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, stringInspector, intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryArg1() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeArg1() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryArg2() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeArg2() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, floatInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategorysArg3() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeArg3() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, floatInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test
    public void partial1ModeDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            UnionDoubleSummaryWithModeSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch1.update(1L, (Object)1.0);
            sketch1.update(2L, (Object)2.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray())});
            UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch2.update(1L, (Object)2.0);
            sketch2.update(2L, (Object)1.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray())});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Assert.assertEquals((String)((Text)r.get(1)).toString(), (String)DoubleSummary.Mode.Sum.toString());
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            TupleSketchIterator it = resultSketch.iterator();
            while (it.next()) {
                Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0);
            }
        }
    }

    @Test
    public void partial1ModeExplicitParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, stringInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            UnionDoubleSummaryWithModeSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            int nomNumEntries = 16;
            State state = (State)eval.getNewAggregationBuffer();
            UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16).build();
            sketch1.update(1L, (Object)1.0);
            sketch1.update(2L, (Object)2.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray()), new IntWritable(16), new Text("Max")});
            UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16).build();
            sketch2.update(1L, (Object)2.0);
            sketch2.update(2L, (Object)1.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray()), new IntWritable(16), new Text("Max")});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)16);
            Assert.assertEquals((String)((Text)r.get(1)).toString(), (String)DoubleSummary.Mode.Max.toString());
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            TupleSketchIterator it = resultSketch.iterator();
            while (it.next()) {
                Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)2.0);
            }
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, new ObjectInspector[]{structInspector});
            UnionDoubleSummaryWithModeSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch1.update(1L, (Object)1.0);
            sketch1.update(2L, (Object)2.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new Text("Sum"), new BytesWritable(sketch1.compact().toByteArray())));
            UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch2.update(1L, (Object)2.0);
            sketch2.update(2L, (Object)1.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new Text("Sum"), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Assert.assertEquals((String)((Text)r.get(1)).toString(), (String)DoubleSummary.Mode.Sum.toString());
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            TupleSketchIterator it = resultSketch.iterator();
            while (it.next()) {
                Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0);
            }
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{structInspector});
            DataToDoubleSummarySketchUDAFTest.checkFinalResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch1.update(1L, (Object)1.0);
            sketch1.update(2L, (Object)2.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new Text("Min"), new BytesWritable(sketch1.compact().toByteArray())));
            UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch2.update(1L, (Object)2.0);
            sketch2.update(2L, (Object)1.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new Text("Min"), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            TupleSketchIterator it = resultSketch.iterator();
            while (it.next()) {
                Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
            }
        }
    }

    @Test
    public void completeModeDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToDoubleSummarySketchUDAFTest.checkFinalResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch1.update(1L, (Object)1.0);
            sketch1.update(2L, (Object)2.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray())});
            UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch2.update(1L, (Object)2.0);
            sketch2.update(2L, (Object)1.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray())});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            TupleSketchIterator it = resultSketch.iterator();
            while (it.next()) {
                Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0);
            }
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void completeModeExplicitNominalNumEntries() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToDoubleSummarySketchUDAFTest.checkFinalResultInspector(resultInspector);
            int nomNumEntries = 16;
            State state = (State)eval.getNewAggregationBuffer();
            UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16).build();
            sketch1.update(1L, (Object)1.0);
            sketch1.update(2L, (Object)2.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray()), new IntWritable(16)});
            UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16).build();
            sketch2.update(1L, (Object)2.0);
            sketch2.update(2L, (Object)1.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray()), new IntWritable(16)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            TupleSketchIterator it = resultSketch.iterator();
            while (it.next()) {
                Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0);
            }
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void completeModeExplicitNominalNumEntriesAndMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, intInspector, stringInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionDoubleSummaryWithModeSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToDoubleSummarySketchUDAFTest.checkFinalResultInspector(resultInspector);
            int nomNumEntries = 16;
            State state = (State)eval.getNewAggregationBuffer();
            UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16).build();
            sketch1.update(1L, (Object)1.0);
            sketch1.update(2L, (Object)2.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch1.compact().toByteArray()), new IntWritable(16), new Text("Max")});
            UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).setNominalEntries(16).build();
            sketch2.update(1L, (Object)2.0);
            sketch2.update(2L, (Object)1.0);
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch2.compact().toByteArray()), new IntWritable(16), new Text("Max")});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            TupleSketchIterator it = resultSketch.iterator();
            while (it.next()) {
                Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)2.0);
            }
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    static void checkIntermediateResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.STRUCT);
        StructObjectInspector structResultInspector = (StructObjectInspector)resultInspector;
        List fields = structResultInspector.getAllStructFieldRefs();
        Assert.assertEquals((int)fields.size(), (int)3);
        ObjectInspector inspector1 = ((StructField)fields.get(0)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector1.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector1 = (PrimitiveObjectInspector)inspector1;
        Assert.assertEquals((Object)primitiveInspector1.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.INT);
        ObjectInspector inspector2 = ((StructField)fields.get(1)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector2.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector2 = (PrimitiveObjectInspector)inspector2;
        Assert.assertEquals((Object)primitiveInspector2.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.STRING);
        ObjectInspector inspector3 = ((StructField)fields.get(2)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector3.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector3 = (PrimitiveObjectInspector)inspector3;
        Assert.assertEquals((Object)primitiveInspector3.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }
}

