/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import java.util.Arrays;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.cpc.State;
import org.apache.datasketches.hive.cpc.UnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

abstract class SketchEvaluator
extends GenericUDAFEvaluator {
    static final int DEFAULT_LG_K = 11;
    protected static final String LG_K_FIELD = "lgK";
    protected static final String SEED_FIELD = "seed";
    protected static final String SKETCH_FIELD = "sketch";
    protected PrimitiveObjectInspector inputInspector_;
    protected PrimitiveObjectInspector lgKInspector_;
    protected PrimitiveObjectInspector seedInspector_;
    protected StructObjectInspector intermediateInspector_;

    SketchEvaluator() {
    }

    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        State state = (State)buf;
        CpcSketch intermediate = state.getResult();
        if (intermediate == null) {
            return null;
        }
        byte[] bytes = intermediate.toByteArray();
        return Arrays.asList(new IntWritable(state.getLgK()), new LongWritable(state.getSeed()), new BytesWritable(bytes));
    }

    public void merge(GenericUDAFEvaluator.AggregationBuffer buf, Object data) throws HiveException {
        if (data == null) {
            return;
        }
        UnionState state = (UnionState)buf;
        if (!state.isInitialized()) {
            this.initializeState(state, data);
        }
        BytesWritable serializedSketch = (BytesWritable)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(SKETCH_FIELD));
        state.update(CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), (long)state.getSeed()));
    }

    private void initializeState(UnionState state, Object data) {
        int lgK = ((IntWritable)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(LG_K_FIELD))).get();
        long seed = ((LongWritable)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(SEED_FIELD))).get();
        state.init(lgK, seed);
    }

    public Object terminate(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        State state = (State)buf;
        if (state == null) {
            return null;
        }
        CpcSketch result = state.getResult();
        if (result == null) {
            return null;
        }
        return new BytesWritable(result.toByteArray());
    }

    public void reset(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        State state = (State)buf;
        state.reset();
    }
}

