/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.quantiles.DoublesUnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;

abstract class DoublesEvaluator
extends GenericUDAFEvaluator {
    protected PrimitiveObjectInspector inputObjectInspector;
    protected PrimitiveObjectInspector kObjectInspector;

    DoublesEvaluator() {
    }

    public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
        super.init(mode, parameters);
        this.inputObjectInspector = (PrimitiveObjectInspector)parameters[0];
        if ((mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) && parameters.length > 1) {
            this.kObjectInspector = (PrimitiveObjectInspector)parameters[1];
        }
        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }

    public void reset(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        DoublesUnionState state = (DoublesUnionState)buf;
        state.reset();
    }

    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        return this.terminate(buf);
    }

    public void merge(GenericUDAFEvaluator.AggregationBuffer buf, Object data) throws HiveException {
        if (data == null) {
            return;
        }
        DoublesUnionState state = (DoublesUnionState)buf;
        Memory serializedSketch = BytesWritableHelper.wrapAsMemory((BytesWritable)this.inputObjectInspector.getPrimitiveWritableObject(data));
        state.update(serializedSketch);
    }

    public Object terminate(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        DoublesUnionState state = (DoublesUnionState)buf;
        DoublesSketch resultSketch = state.getResult();
        if (resultSketch == null) {
            return null;
        }
        return new BytesWritable(resultSketch.toByteArray(true));
    }

    public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new DoublesUnionState();
    }
}

