/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantilescommon.FloatsSketchSortedView;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.req.BaseReqSketch;
import org.apache.datasketches.req.ReqSketch;
import org.apache.datasketches.req.ReqSketchBuilder;
import org.apache.datasketches.req.ReqSketchTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReqSketchOtherTest {
    final ReqSketchTest reqSketchTest = new ReqSketchTest();
    static InequalitySearch critLT = InequalitySearch.LT;
    static InequalitySearch critLE = InequalitySearch.LE;
    static InequalitySearch critGT = InequalitySearch.GT;
    static InequalitySearch critGE = InequalitySearch.GE;

    @Test
    public void checkConstructors() {
        ReqSketch sk = ReqSketch.builder().build();
        Assert.assertEquals((int)sk.getK(), (int)12);
    }

    @Test
    public void checkCopyConstructors() {
        boolean ltEq = true;
        ReqSketch sk = this.reqSketchTest.loadSketch(6, 1, 50, true, true, 0);
        long n = sk.getN();
        float min = sk.getMinItem();
        float max = sk.getMaxItem();
        ReqSketch sk2 = new ReqSketch(sk);
        Assert.assertEquals((float)sk2.getMinItem(), (float)min);
        Assert.assertEquals((float)sk2.getMaxItem(), (float)max);
    }

    @Test
    public void checkNonFinitePMF_CDF() {
        ReqSketch sk = ReqSketch.builder().build();
        sk.update(1.0f);
        try {
            sk.getCDF(new float[]{Float.NaN});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkQuantilesExceedLimits() {
        boolean ltEq = true;
        ReqSketch sk = this.reqSketchTest.loadSketch(6, 1, 200, true, true, 0);
        try {
            sk.getQuantile(2.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getQuantile(-2.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkEstimationMode() {
        boolean up = true;
        boolean hra = true;
        boolean ltEq = true;
        ReqSketch sk = this.reqSketchTest.loadSketch(20, 1, 119, true, true, 0);
        Assert.assertEquals((boolean)sk.isEstimationMode(), (boolean)false);
        double lb = sk.getRankLowerBound(1.0, 1);
        double ub = sk.getRankUpperBound(1.0, 1);
        Assert.assertEquals((double)lb, (double)1.0);
        Assert.assertEquals((double)ub, (double)1.0);
        int maxNomSize = sk.getMaxNomSize();
        Assert.assertEquals((int)maxNomSize, (int)120);
        sk.update(120.0f);
        Assert.assertEquals((boolean)sk.isEstimationMode(), (boolean)true);
        maxNomSize = sk.getMaxNomSize();
        Assert.assertEquals((int)maxNomSize, (int)240);
        float v = sk.getQuantile(1.0);
        Assert.assertEquals((float)v, (float)120.0f);
        FloatsSketchSortedView aux = sk.getSortedView();
        Assert.assertNotNull((Object)aux);
        Assert.assertTrue((BaseReqSketch.getRSE((int)sk.getK(), (double)0.5, (boolean)false, (long)120L) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((sk.getSerializedSizeBytes() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void checkNaNUpdate() {
        InequalitySearch criterion = InequalitySearch.LE;
        ReqSketch sk = ReqSketch.builder().build();
        sk.update(Float.NaN);
        Assert.assertTrue((boolean)sk.isEmpty());
    }

    @Test
    public void checkNonFiniteGetRank() {
        ReqSketch sk = ReqSketch.builder().build();
        sk.update(1.0f);
        try {
            sk.getRank(Float.POSITIVE_INFINITY);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void moreMergeTests() {
        int i;
        ReqSketch sk1 = ReqSketch.builder().build();
        ReqSketch sk2 = ReqSketch.builder().build();
        for (i = 5; i < 10; ++i) {
            sk1.update((float)i);
        }
        sk1.merge(sk2);
        for (i = 1; i <= 15; ++i) {
            sk2.update((float)i);
        }
        sk1.merge(sk2);
        Assert.assertEquals((long)sk1.getN(), (long)20L);
        for (i = 16; i <= 300; ++i) {
            sk2.update((float)i);
        }
        sk1.merge(sk2);
    }

    @Test
    public void simpleTest() {
        ReqSketchBuilder bldr = ReqSketch.builder();
        bldr.setK(50).setHighRankAccuracy(false);
        bldr.setReqDebug(null);
        ReqSketch sk = bldr.build();
        float[] vArr = new float[]{5.0f, 5.0f, 5.0f, 6.0f, 6.0f, 6.0f, 7.0f, 8.0f, 8.0f, 8.0f};
        for (int i = 0; i < vArr.length; ++i) {
            sk.update(vArr[i]);
        }
        double[] rArrLT = new double[]{0.0, 0.0, 0.0, 0.3, 0.3, 0.3, 0.6, 0.7, 0.7, 0.7};
        for (int i = 0; i < vArr.length; ++i) {
            Assert.assertEquals((double)sk.getRank(vArr[i], QuantileSearchCriteria.EXCLUSIVE), (double)rArrLT[i]);
        }
        double[] rArrLE = new double[]{0.3, 0.3, 0.3, 0.6, 0.6, 0.6, 0.7, 1.0, 1.0, 1.0};
        for (int i = 0; i < vArr.length; ++i) {
            Assert.assertEquals((double)sk.getRank(vArr[i], QuantileSearchCriteria.INCLUSIVE), (double)rArrLE[i]);
        }
    }

    @Test
    public void checkGetRankUBLB() {
        this.checkGetRank(true, false);
        this.checkGetRank(false, true);
    }

    @Test
    public void checkEmpty() {
        ReqSketchBuilder bldr = new ReqSketchBuilder();
        ReqSketch sk = bldr.build();
        try {
            sk.getRank(1.0f);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sk.getRanks(new float[]{1.0f});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sk.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sk.getQuantiles(new double[]{0.5});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sk.getPMF(new float[]{1.0f});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sk.getCDF(new float[]{1.0f});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((BaseReqSketch.getRSE((int)50, (double)0.5, (boolean)true, (long)0L) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((sk.getRankUpperBound(0.5, 1) > 0.0 ? 1 : 0) != 0);
    }

    private void checkGetRank(boolean hra, boolean ltEq) {
        int k = 12;
        boolean up = true;
        boolean min = true;
        int max = 1000;
        boolean skDebug = false;
        ReqSketch sk = this.reqSketchTest.loadSketch(12, 1, 1000, true, hra, 0);
        double rLB = sk.getRankLowerBound(0.5, 1);
        Assert.assertTrue((rLB > 0.0 ? 1 : 0) != 0);
        rLB = hra ? sk.getRankLowerBound(0.995, 1) : sk.getRankLowerBound(0.005, 1);
        Assert.assertTrue((rLB > 0.0 ? 1 : 0) != 0);
        double rUB = sk.getRankUpperBound(0.5, 1);
        Assert.assertTrue((rUB > 0.0 ? 1 : 0) != 0);
        rUB = hra ? sk.getRankUpperBound(0.995, 1) : sk.getRankUpperBound(0.005, 1);
        Assert.assertTrue((rUB > 0.0 ? 1 : 0) != 0);
        double[] ranks = sk.getRanks(new float[]{5.0f, 100.0f});
    }

    private static void myAssertEquals(double v1, double v2) {
        if ((!Double.isNaN(v1) || !Double.isNaN(v2)) && v1 != v2) assert (false);
    }

    private static void myAssertEquals(float v1, float v2) {
        if ((!Float.isNaN(v1) || !Float.isNaN(v2)) && v1 != v2) assert (false);
    }
}

