/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.filters.bloomfilter.BitArray;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

public class DirectBitArrayR
extends BitArray {
    protected static final long NUM_BITS_OFFSET = 8L;
    protected static final long DATA_OFFSET = 16L;
    protected final int dataLength_;
    protected final WritableMemory wmem_;
    protected long numBitsSet_;

    protected DirectBitArrayR(int dataLength, long storedNumBitsSet, Memory mem) {
        this.dataLength_ = dataLength;
        this.wmem_ = (WritableMemory)mem;
        if (storedNumBitsSet == -1L) {
            this.numBitsSet_ = 0L;
            for (int i = 0; i < this.dataLength_; ++i) {
                this.numBitsSet_ += (long)Long.bitCount(this.wmem_.getLong(16L + (long)(i << 3)));
            }
        } else {
            this.numBitsSet_ = storedNumBitsSet;
        }
    }

    static DirectBitArrayR wrap(Memory mem, boolean isEmpty) {
        long storedNumBitsSet;
        int arrayLength = mem.getInt(0L);
        long l = storedNumBitsSet = isEmpty ? 0L : mem.getLong(8L);
        if (arrayLength < 0) {
            throw new SketchesArgumentException("Possible corruption: Serialized image indicates non-positive array length");
        }
        if (storedNumBitsSet != 0L && mem.getCapacity() < (long)(arrayLength + 2)) {
            throw new SketchesArgumentException("Memory capacity insufficient for Bloom Filter. Needed: " + (arrayLength + 2) + " , found: " + mem.getCapacity());
        }
        return new DirectBitArrayR(arrayLength, storedNumBitsSet, mem);
    }

    @Override
    long getCapacity() {
        return (long)this.dataLength_ * 64L;
    }

    @Override
    long getNumBitsSet() {
        return this.numBitsSet_;
    }

    @Override
    protected boolean isDirty() {
        return false;
    }

    @Override
    int getArrayLength() {
        return this.dataLength_;
    }

    @Override
    boolean getBit(long index) {
        if (this.isEmpty()) {
            return false;
        }
        return (this.wmem_.getByte(16L + (long)((int)index >>> 3)) & 1 << (int)(index & 7L)) != 0;
    }

    @Override
    protected long getLong(int arrayIndex) {
        if (this.isEmpty()) {
            return 0L;
        }
        return this.wmem_.getLong(16L + (long)(arrayIndex << 3));
    }

    @Override
    public boolean hasMemory() {
        return this.wmem_ != null;
    }

    @Override
    public boolean isDirect() {
        return this.wmem_ != null ? this.wmem_.isDirect() : false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    void reset() {
        throw new SketchesReadOnlyException("Attempt to call reset() on read-only memory");
    }

    @Override
    void setBit(long index) {
        throw new SketchesReadOnlyException("Attempt to call setBit() on read-only memory");
    }

    @Override
    boolean getAndSetBit(long index) {
        throw new SketchesReadOnlyException("Attempt to call getAndSetBit() on read-only memory");
    }

    @Override
    void intersect(BitArray other) {
        throw new SketchesReadOnlyException("Attempt to call intersect() on read-only memory");
    }

    @Override
    void union(BitArray other) {
        throw new SketchesReadOnlyException("Attempt to call union() on read-only memory");
    }

    @Override
    void invert() {
        throw new SketchesReadOnlyException("Attempt to call invert() on read-only memory");
    }

    @Override
    protected void setLong(int arrayIndex, long value) {
        throw new SketchesReadOnlyException("Attempt to call setLong() on read-only memory");
    }
}

