/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.util.ArrayList;
import org.apache.datasketches.memory.internal.Ints;
import org.apache.datasketches.memory.internal.UnsafeUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnsafeUtilTest {
    long testField = 1L;

    @Test
    public void checkFieldOffset() {
        Assert.assertEquals((long)this.testField, (long)1L);
        long offset = UnsafeUtil.getFieldOffset(this.getClass(), (String)"testField");
        Assert.assertEquals((long)offset, (long)16L);
        try {
            offset = UnsafeUtil.getFieldOffset(this.getClass(), (String)"testField2");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkInts() {
        Ints.checkedCast((long)0x100000000L);
    }

    @Test
    public void checkArrayBaseOffset() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(byte[].class);
        classes.add(int[].class);
        classes.add(long[].class);
        classes.add(float[].class);
        classes.add(double[].class);
        classes.add(boolean[].class);
        classes.add(short[].class);
        classes.add(char[].class);
        classes.add(Object[].class);
        classes.add(byte[][].class);
        for (Class clazz : classes) {
            Assert.assertEquals((long)UnsafeUtil.getArrayBaseOffset((Class)clazz), (long)UnsafeUtil.unsafe.arrayBaseOffset(clazz), (String)clazz.getTypeName());
        }
    }

    @Test
    public void printlnTest() {
        UnsafeUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

