/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.Util;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.log4j.Logger;
import org.apache.pig.Accumulator;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

abstract class UnionArrayOfDoublesSketchBase
extends EvalFunc<Tuple>
implements Accumulator<Tuple> {
    private final int sketchSize_;
    private final int numValues_;
    private ArrayOfDoublesUnion accumUnion_;
    private boolean isFirstCall_ = true;

    UnionArrayOfDoublesSketchBase() {
        this(4096, 1);
    }

    UnionArrayOfDoublesSketchBase(int numValues) {
        this(4096, numValues);
    }

    UnionArrayOfDoublesSketchBase(int sketchSize, int numValues) {
        this.sketchSize_ = sketchSize;
        this.numValues_ = numValues;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"exec is used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return null;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setNominalEntries(this.sketchSize_).setNumberOfValues(this.numValues_).buildUnion();
        UnionArrayOfDoublesSketchBase.updateUnion(bag, union);
        return Util.tupleFactory.newTuple((Object)new DataByteArray(union.getResult().toByteArray()));
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"accumulator is used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() != 1) {
            return;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null || bag.size() == 0L) {
            return;
        }
        if (this.accumUnion_ == null) {
            this.accumUnion_ = new ArrayOfDoublesSetOperationBuilder().setNominalEntries(this.sketchSize_).setNumberOfValues(this.numValues_).buildUnion();
        }
        UnionArrayOfDoublesSketchBase.updateUnion(bag, this.accumUnion_);
    }

    public Tuple getValue() {
        if (this.accumUnion_ == null) {
            return Util.tupleFactory.newTuple((Object)new DataByteArray(new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(this.numValues_).build().compact().toByteArray()));
        }
        return Util.tupleFactory.newTuple((Object)new DataByteArray(this.accumUnion_.getResult().toByteArray()));
    }

    public void cleanup() {
        if (this.accumUnion_ != null) {
            this.accumUnion_.reset();
        }
    }

    private static void updateUnion(DataBag bag, ArrayOfDoublesUnion union) throws ExecException {
        for (Tuple innerTuple : bag) {
            if (innerTuple.size() != 1 || innerTuple.get(0) == null) continue;
            DataByteArray dba = (DataByteArray)innerTuple.get(0);
            union.union(ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])dba.get())));
        }
    }
}

