/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpdatableResultSetTest
extends BaseJDBCTestCase {
    private static final byte[] BYTES1 = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
    private static final byte[] BYTES2 = new byte[]{105, 104, 103, 102, 101, 101, 102, 103, 104, 105};
    private static int insertKey = 0;
    private int key = -1;

    public UpdatableResultSetTest(String string) {
        super(string);
    }

    protected void setUp() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.execute("create table UpdateTestTableResultSet (sno int not null unique,dBlob BLOB,dClob CLOB,dLongVarchar LONG VARCHAR,dLongBit LONG VARCHAR FOR BIT DATA)");
        statement.executeUpdate("create table \"my \"\"quoted\"\" table\" (x int)");
        statement.executeUpdate("insert into \"my \"\"quoted\"\" table\" (x) values (1), (2), (3)");
        statement.executeUpdate("create table \"my quoted columns\" (\"my \"\"quoted\"\" column\" int)");
        statement.executeUpdate("insert into \"my quoted columns\" values (1), (2), (3) ");
        statement.executeUpdate("create table \"my \"\"quoted\"\" schema\".\"my quoted schema\" (x int)");
        statement.executeUpdate("insert into \"my \"\"quoted\"\" schema\".\"my quoted schema\" values (1), (2), (3) ");
        statement.executeUpdate("create table \"my table\" (x int)");
        statement.executeUpdate("insert into \"my table\" values (1), (2), (3) ");
        statement.close();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(UpdatableResultSetTest.class);
    }

    public void testInsertRowOnQuotedTable() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" table\"");
        resultSet.next();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 4);
        resultSet.insertRow();
        resultSet.moveToCurrentRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" table\" order by x");
        for (int i = 1; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowOnQuotedTable() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" table\"");
        resultSet.next();
        resultSet.updateInt(1, 4);
        resultSet.updateRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" table\" order by x");
        for (int i = 2; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testDeleteRowOnQuotedTable() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" table\"");
        resultSet.next();
        resultSet.deleteRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" table\" order by x");
        for (int i = 2; i <= 3; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testInsertRowOnQuotedColumn() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("select * from \"my quoted columns\"");
        resultSet.next();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 4);
        resultSet.insertRow();
        resultSet.moveToCurrentRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my quoted columns\" order by \"my \"\"quoted\"\" column\"");
        for (int i = 1; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowOnQuotedColumn() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("select * from \"my quoted columns\"");
        resultSet.next();
        resultSet.updateInt(1, 4);
        resultSet.updateRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my quoted columns\" order by \"my \"\"quoted\"\" column\"");
        for (int i = 2; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testDeleteRowOnQuotedColumn() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("select * from \"my quoted columns\"");
        resultSet.next();
        resultSet.deleteRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my quoted columns\" order by \"my \"\"quoted\"\" column\"");
        for (int i = 2; i <= 3; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testInsertRowOnQuotedSchema() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\"");
        resultSet.next();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 4);
        resultSet.insertRow();
        resultSet.moveToCurrentRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\" order by x");
        for (int i = 1; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowOnQuotedSchema() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\"");
        resultSet.next();
        resultSet.updateInt(1, 4);
        resultSet.updateRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\" order by x");
        for (int i = 2; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testDeleteRowOnQuotedSchema() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\"");
        resultSet.next();
        resultSet.deleteRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my \"\"quoted\"\" schema\".\"my quoted schema\" order by x");
        for (int i = 2; i <= 3; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testInsertRowOnQuotedCursor() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName("my \"\"\"\"quoted\"\"\"\" cursor\"\"");
        resultSet = statement.executeQuery("select * from \"my table\"");
        resultSet.next();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 4);
        resultSet.insertRow();
        resultSet.moveToCurrentRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my table\" order by x");
        for (int i = 1; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowOnQuotedCursor() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName("\"\"my quoted cursor");
        resultSet = statement.executeQuery("select * from \"my table\"");
        resultSet.next();
        resultSet.updateInt(1, 4);
        resultSet.updateRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my table\" order by x");
        for (int i = 2; i <= 4; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testDeleteRowOnQuotedCursor() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName("\"\"my quoted cursor\"\"");
        resultSet = statement.executeQuery("select * from \"my table\"");
        resultSet.next();
        resultSet.deleteRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from \"my table\" order by x");
        for (int i = 2; i <= 3; ++i) {
            UpdatableResultSetTest.assertTrue((String)"there is a row", (boolean)resultSet.next());
            UpdatableResultSetTest.assertEquals((String)"row contains correct value", (int)i, (int)resultSet.getInt(1));
        }
        resultSet.close();
        statement.close();
    }

    public void testUpdateBlob() throws Exception {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dBlob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        int n = UpdatableResultSetTest.requestKey();
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream2, BYTES2.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetch("dBlob", this.key);
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        resultSet.close();
        resultSet = this.fetchUpd("dBlob", n);
        resultSet.next();
        resultSet.updateBlob(1, blob);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dBlob", n);
        resultSet.next();
        UpdatableResultSetTest.assertEquals(blob, resultSet.getBlob(1));
        resultSet.close();
    }

    public void testUpdateBlobStringParameterName() throws Exception {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dBlob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        int n = UpdatableResultSetTest.requestKey();
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream2, BYTES2.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetch("dBlob", this.key);
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        resultSet.close();
        resultSet = this.fetchUpd("dBlob", n);
        resultSet.next();
        resultSet.updateBlob("dBlob", blob);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dBlob", n);
        resultSet.next();
        UpdatableResultSetTest.assertEquals(blob, resultSet.getBlob(1));
        resultSet.close();
    }

    public void testUpdateClob() throws Exception {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dClob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        int n = UpdatableResultSetTest.requestKey();
        preparedStatement.setInt(1, n);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream2, BYTES2.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dClob", this.key);
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        resultSet.close();
        resultSet = this.fetchUpd("dClob", n);
        resultSet.next();
        resultSet.updateClob(1, clob);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dClob", n);
        resultSet.next();
        UpdatableResultSetTest.assertEquals(clob, resultSet.getClob(1));
        resultSet.close();
    }

    public void testUpdateClobStringParameterName() throws Exception {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dClob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        int n = UpdatableResultSetTest.requestKey();
        preparedStatement.setInt(1, n);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream2, BYTES2.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetch("dClob", this.key);
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        resultSet.close();
        resultSet = this.fetchUpd("dClob", n);
        resultSet.next();
        resultSet.updateClob("dClob", clob);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dClob", n);
        resultSet.next();
        UpdatableResultSetTest.assertEquals(clob, resultSet.getClob(1));
        resultSet.close();
    }

    private static final int requestKey() {
        return ++insertKey;
    }

    private PreparedStatement prep(String string) throws SQLException {
        return this.prepareStatement("insert into UpdateTestTableResultSet (sno, " + string + ") values (?,?)");
    }

    private ResultSet fetchUpd(String string, int n) throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        return statement.executeQuery("select " + string + " from UpdateTestTableResultSet where sno = " + n + " for update");
    }

    private ResultSet fetch(String string, int n) throws SQLException {
        Statement statement = this.createStatement();
        return statement.executeQuery("select " + string + " from UpdateTestTableResultSet where sno = " + n);
    }

    public void testDerby6981() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE TEST1 (ID int PRIMARY KEY NOT NULL,LASTUPDATE timestamp)");
        PreparedStatement preparedStatement = this.prepareStatement("SELECT id, LASTUPDATE FROM test1 WHERE id = ? FOR UPDATE OF id, LASTUPDATE ", 1003, 1008);
        long l = new Date().getTime();
        for (int i = 0; i < 3; ++i) {
            preparedStatement.setInt(1, 3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                resultSet.moveToInsertRow();
                resultSet.updateInt(1, 3);
                resultSet.updateTimestamp(2, new Timestamp(l));
                resultSet.insertRow();
            } else {
                resultSet.updateInt(1, 3);
                resultSet.updateTimestamp(2, new Timestamp(l));
                resultSet.updateRow();
            }
            resultSet.close();
        }
        statement.close();
        preparedStatement.close();
    }
}

