/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby3980DeadlockTest
extends BaseJDBCTestCase {
    private final int THREAD_COUNT = 2;
    private final LinkedList<Throwable> listExceptions = new LinkedList();
    private final Object syncObject = new Object();
    private int startedCount = 0;
    private static final String fprefix = "javacore";
    private static final String POLICY_FILE_NAME = "org/apache/derbyTesting/functionTests/tests/store/Derby3980DeadlockTest.policy";

    public Derby3980DeadlockTest(String string) {
        super(string);
    }

    public void test3980Deadlock() {
        Thread[] threadArray = new Thread[2];
        this.createThreads(threadArray);
        this.waitForThreads(threadArray);
        this.checkExceptions();
    }

    private void checkExceptions() {
        for (Throwable throwable : this.listExceptions) {
            if (throwable instanceof SQLException) {
                Derby3980DeadlockTest.assertSQLState("40001", (SQLException)throwable);
                continue;
            }
            Derby3980DeadlockTest.fail("Unexpected exception", throwable);
        }
        Derby3980DeadlockTest.assertEquals((String)("Expected 1 exception, got" + this.listExceptions.size()), (int)1, (int)this.listExceptions.size());
    }

    private static Test decorateTest() {
        Object object = TestConfiguration.clientServerSuite(Derby3980DeadlockTest.class);
        Properties properties = new Properties();
        properties.setProperty("derby.stream.error.extendedDiagSeverityLevel", "30000");
        properties.setProperty("derby.infolog.append", "true");
        object = new SystemPropertyTestSetup((Test)object, properties, true);
        return new SecurityManagerSetup((Test)object, POLICY_FILE_NAME);
    }

    private void waitForThreads(Thread[] threadArray) {
        for (int i = 0; i < 2; ++i) {
            try {
                threadArray[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                Derby3980DeadlockTest.fail((String)"FAIL - InterruptedException  thrown waiting for the threads");
            }
        }
    }

    private void createThreads(Thread[] threadArray) {
        for (int i = 0; i < 2; ++i) {
            threadArray[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    this.threadWorker();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void threadWorker() {
                    Connection connection = null;
                    try {
                        Object object = Derby3980DeadlockTest.this.syncObject;
                        synchronized (object) {
                            if (connection == null) {
                                connection = Derby3980DeadlockTest.this.openDefaultConnection();
                            }
                            Derby3980DeadlockTest.this.startedCount++;
                            Derby3980DeadlockTest.this.syncObject.notifyAll();
                            while (Derby3980DeadlockTest.this.startedCount < 2) {
                                Derby3980DeadlockTest.this.syncObject.wait();
                            }
                        }
                        object = connection.createStatement();
                        connection.setAutoCommit(false);
                        connection.setTransactionIsolation(4);
                        ResultSet resultSet = object.executeQuery("select * from t where i = 456");
                        while (resultSet.next()) {
                        }
                        object.executeUpdate("delete from t  where i = 456");
                        connection.commit();
                    }
                    catch (Exception exception) {
                        Object object = Derby3980DeadlockTest.this.syncObject;
                        synchronized (object) {
                            Derby3980DeadlockTest.this.listExceptions.add(exception);
                        }
                    }
                }
            }, "Thread" + i);
            threadArray[i].start();
        }
    }

    public static Test suite() {
        Test test = Derby3980DeadlockTest.decorateTest();
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts(test, 5, 10)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("CREATE TABLE T (I INT)");
                statement.executeUpdate("INSERT INTO T VALUES(456)");
            }
        };
    }

    @Override
    protected void tearDown() throws Exception {
        String string = BaseTestCase.getSystemProperty("user.dir");
        try {
            File file = new File(string);
            String[] stringArray = BaseTestCase.getFilesWith(file, fprefix);
            Derby3980DeadlockTest.removeFiles(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Derby3980DeadlockTest.fail((String)"open directory");
        }
        super.tearDown();
    }
}

